% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEcollect.R
\name{metaGE.collect}
\alias{metaGE.collect}
\title{Collect the results of GWAS data from different files}
\usage{
metaGE.collect(
  FileNames,
  VariableNames,
  MinFreq = 0,
  DropDuplicates = TRUE,
  Verbose = FALSE,
  NA.rmv = TRUE
)
}
\arguments{
\item{FileNames}{A list containing the file paths to merge (one trait only) or a list of such lists}

\item{VariableNames}{A named list containing the column names in the original files corresponding to the variables below:
\itemize{
\item MARKER, CHR, POS, EFFECT, EFFECT_SE, PVAL,
\item (optional: FREQ, ALLELE0, ALLELE1, WEIGHT)
or a list of such lists.
}}

\item{MinFreq}{A numeric value allowing to filter markers based on the maf. (optional)}

\item{DropDuplicates}{A boolean indicating whether duplicate markers should be removed or not. (TRUE by default)}

\item{Verbose}{A boolean indicating whether progression messages should be printed or not. (FALSE by default)}

\item{NA.rmv}{A boolean should the NA be removed or not (TRUE by default)}
}
\value{
A list of:
\itemize{
\item Data ->  a tibble containing all the columns of interest of all the files from FileNames,
\item RemovedMarkers -> same kind of tibble, but containing the markers that have been removed due to unclear allele coding.
}
}
\description{
This function merges files containing the summary statistics of GWAS in different environments (one file per environment).
}
\details{
Each file MUST contain the variables below:
\itemize{
\item MARKER =  marker,
\item CHR = the chromosome ,
\item POS = the position of the marker on the chromosome,
\item EFFECT = the mean effect of the marker,
\item EFFECT_SE = the standard error of the mean effect,
\item PVAL = the pvalue of the mean effect.
Each file might contain the variables:
\item FREQ = MAF
\item ALLELE0
\item ALLELE1
\item WEIGHT
}
}
\examples{
require(dplyr)
require(tibble)
require(stringr)
RepData <- system.file("extdata", package = "metaGE")
# Get the complete list of association files
File.list <- list.files(RepData ,full.names = TRUE) \%>\%
            tibble(Names = .) \%>\%
            mutate(ShortNames = Names \%>\%
                  str_remove(pattern = paste0(RepData,"/")) \%>\%
                  str_remove(pattern = "_DF.txt"))  \%>\%
            select(ShortNames,Names) \%>\%
            deframe
###Build the dataset
## First provide the list of variable names
Names.list <- list(MARKER="Marker_Name",
                  CHR="Chromosome",
                  POS="Marker_Position",
                  FREQ="Maf",
                  EFFECT="SNP_Weight",
                  PVAL="Pvalue",
                  ALLELE0="Allele1",
                  ALLELE1="Allele2")

MinFreq <- 0.07

## Now collect
metaData <- metaGE.collect(File.list, Names.list,MinFreq = MinFreq)
}
