% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/60_data.R
\name{download_example_datasets}
\alias{download_example_datasets}
\title{Download metabodecon Example Datasets}
\usage{
download_example_datasets(
  dst_dir = NULL,
  extract = TRUE,
  persistent = NULL,
  overwrite = FALSE,
  silent = FALSE
)
}
\arguments{
\item{dst_dir}{The destination directory where the downloaded datasets will be stored. If
NULL, the function will return the path to the cached zip file.}

\item{extract}{Logical. If TRUE, the downloaded zip file will be extracted.}

\item{persistent}{Logical. If TRUE, the downloaded datasets will be cached at
\code{\link[=datadir_persistent]{datadir_persistent()}} to speed up future calls to
\code{download_example_datasets()}. If FALSE, the datasets will be cached at
\code{\link[=datadir_temp]{datadir_temp()}}. If NULL, the function will check both paths for the cached
datasets but will return \code{\link[=datadir_temp]{datadir_temp()}} if the cached file does not yet
exist.}

\item{overwrite}{Logical. If TRUE, existing files with the same name in the destination
directory will be overwritten.}

\item{silent}{Logical. If TRUE, no output will be printed to the console.}
}
\value{
The path to the downloaded (and possibly extracted) datasets.
}
\description{
Downloads example datasets that can be used to test the
functionality of the metabodecon package. These datasets are not included in
the package by default due to size constraints. The datasets are downloaded
as zip file and extracted automatically, unless extraction is disabled by the
user.
}
\examples{
if (interactive()) {
     zip <- download_example_datasets(extract = FALSE, persistent = FALSE)
     dir <- download_example_datasets(extract = TRUE)
}

}
\seealso{
\code{\link[=datadir]{datadir()}}
}
