% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_taxonomy.R
\name{extract_taxonomy}
\alias{extract_taxonomy}
\alias{extract_taxonomy.DNAbin}
\alias{extract_taxonomy.default}
\alias{extract_taxonomy.list}
\title{Extract taxonomy information from sequence headers}
\usage{
extract_taxonomy(input, ...)

\method{extract_taxonomy}{default}(input, key = c("class", "taxon_id", "name",
  "taxon_info", "obs_id", "obs_info"), regex = "(.*)", class_key = c("name",
  "taxon_id", "taxon_info"), class_regex = "(.*)", class_sep = NULL,
  class_rev = FALSE, database = c("none", "ncbi", "itis", "eol", "col",
  "tropicos", "nbn"), allow_na = TRUE, vigilance = c("warning", "error",
  "message", "none"), return_match = FALSE, return_input = FALSE,
  redundant_names = FALSE, verbosity = c("low", "none", "high"), ...)

\method{extract_taxonomy}{DNAbin}(input, ...)

\method{extract_taxonomy}{list}(input, ...)
}
\arguments{
\item{input}{A vector from which to extract taxonomy information or an object of class
\code{\link{ape}{DNAbin}}.}

\item{...}{Not used.}

\item{key}{(\code{character}) The identity of the capturing groups defined using \code{regex}.
The length of \code{key} must be equal to the number of capturing groups specified in \code{regex}.
Any names added to the terms will be used as column names in the output.
Only \code{"taxon_info"} and \code{"obs_info"} can be used multiple times.
Each term must be one of those decribed below:
\describe{
  \item{\code{taxon_id}}{A unique numeric id for a taxon for a particular \code{database} (e.g. ncbi accession number).
        Requires an internet connection.}
  \item{\code{name}}{The name of a taxon. Not necessarily unique, but are interpretable
        by a particular \code{database}. Requires an internet connection.}
  \item{\code{taxon_info}}{Arbitrary taxon info you want included in the output. Can be used more than once.}
  \item{\code{class}}{A list of taxa information that consitutes the full taxonomic classification
        from broad to specific (see \code{class_rev}) for a particular \code{database}. Individual taxa
        are separated by the \code{class_sep} argument and the information is parsed by the
        \code{class_regex} and \code{class_key} arguments.}
  \item{\code{obs_id}}{An unique observation (e.g. sequence) identifier for a particular \code{database}.
        Requires an internet connection.}
  \item{\code{obs_info}}{Arbitrary observation info you want included in the output. Can be used more than once.}
}}

\item{regex}{(\code{character; length == 1}) A regular expression with capturing groups
indicating the locations of relevant information. The identity of the information must
be specified using the \code{key} argument.}

\item{class_key}{(\code{character} of length 1)
The identity of the capturing groups defined using \code{class_iregex}.
The length of \code{class_key} must be equal to the number of capturing groups specified in \code{class_regex}.
Any names added to the terms will be used as column names in the output.
At least \code{"taxon_id"} or \code{"name"} must be specified.
Only \code{"taxon_info"} can be used multiple times.
Each term must be one of those decribed below:
 \describe{
   \item{\code{taxon_id}}{A unique numeric id for a taxon for a particular \code{database} (e.g. ncbi accession number).
         Requires an internet connection.}
   \item{\code{name}}{The name of a taxon. Not necessarily unique, but are interpretable
         by a particular \code{database}. Requires an internet connection.}
   \item{\code{taxon_info}}{Arbitrary taxon info you want included in the output. Can be used more than once.}
 }}

\item{class_regex}{(\code{character} of length 1)
A regular expression with capturing groups indicating the locations of data for each taxon in the \code{class} term in the \code{key} argument.
The identity of the information must be specified using the \code{class_key} argument.
The \code{class_sep} option can be used to split the classification into data for each taxon before matching.
If \code{class_sep} is \code{NULL}, each match of \code{class_regex} defines a taxon in the classification.}

\item{class_sep}{(\code{character} of length 1)
Used with the \code{class} term in the \code{key} argument.
The character(s) used to separate individual taxa within a classification.
After the string defined by the \code{class} capture group in \code{regex} is split by \code{class_sep},
its capture groups are extracted by \code{class_regex} and defined by \code{class_key}.
If \code{NULL}, every match of \code{class_regex} is used instead with first splitting by \code{class_sep}.}

\item{class_rev}{(\code{logical} of length 1)
Used with the \code{class} term in the \code{key} argument.
If \code{TRUE}, the order of taxon data in a classfication is reversed to be specific to broad.}

\item{database}{(\code{character} of length 1) The name of the database that patterns given in 
\code{parser} will apply to. Valid databases include "ncbi", "itis", "eol", "col", "tropicos",
"nbn", and "none". \code{"none"} will cause no database to be quired; use this if you want to not use the
internet. NOTE: Only \code{"ncbi"} has been tested so far.}

\item{allow_na}{(\code{logical} of length 1) If \code{TRUE}, any missing data will be represented as \code{NA}s
in the output. This preserves the correspondance between the input and output values.
Missing data can be generated if the regex does not match the input or online queries fail.}

\item{vigilance}{(\code{character} of length 1) Controls the reporting of possible problems, such
as missing data and failed online queries (see \code{allow_na}).
The following values are possible: 
 \describe{
   \item{\code{"none"}}{No warnings or errors are generated if the function can complete.}
   \item{\code{"message"}}{A message is generated when atypical events occur.}
   \item{\code{"warning"}}{Warnings are generated when atypical events occur.}
   \item{\code{"error"}}{Errors are generated when atypical events occur, stopping the completion of the function.}
 }}

\item{return_match}{(\code{logical} of length 1)
If \code{TRUE}, include the part of the input matched by \code{regex} in the output object.}

\item{return_input}{(\code{logical} of length 1) If \code{TRUE}, include the input in the output object.}

\item{redundant_names}{(\code{logical} of length 1)
If \code{TRUE}, remove any occurrence of the a supertaxon's name at the start of the taxon name.
This is useful for removing the redundant genus information in species binomials.}

\item{verbosity}{(\code{character} of length 1) Controls the printing of progress updates.
The following values are possible: 
 \describe{
   \item{\code{"none"}}{No progress reports are printed}
   \item{\code{"low"}}{Minimal progress reports of a fixed length are printed.}
   \item{\code{"high"}}{Lots of information is printed depending on the amount of the input.}
 }}
}
\value{
Returns an object of type \code{taxmap}
}
\description{
Extracts the taxonomy from metadata (e.g. sequence headers) or parsed sequence data. 
The location and identity of important information in the input is specified using a regular expression
with capture groups and an corresponding key.
An object of type \code{\link{taxmap}} is returned containing the specifed information.
Taxa are translated into unique codes if they are not already encoded this way.
}
\examples{
\dontrun{
# Extract embedded classifications from UNITE FASTA file offline
file_path <- system.file("extdata", "unite_general_release.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
unite_ex_data_3 <- extract_taxonomy(sequences,
                                    regex = "^(.*)\\\\|(.*)\\\\|(.*)\\\\|.*\\\\|(.*)$",
                                    key = c(name = "obs_info", seq_id = "obs_info",
                                            other_id = "obs_info", "class_name"),
                                    database = "none")
# Look up taxonomic data online using sequence ID
unite_ex_data <- extract_taxonomy(sequences,
                                  regex = "^(.*)\\\\|(.*)\\\\|(.*)\\\\|.*\\\\|(.*)$",
                                key = c(name = "name", seq_id = "obs_id",
                                       other_id = "obs_info", tax_string = "obs_info"))
}

}

