% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--utilities.R
\name{roots}
\alias{roots}
\title{Get root taxa}
\usage{
roots(obj, subset = NULL, index = FALSE)
}
\arguments{
\item{obj}{(\code{taxmap}) The \code{taxmap} object containing taxon information to be
queried.}

\item{subset}{(\code{character}) Taxon IDs for which supertaxa will be returned. Default: All
taxon in \code{obj} will be used.}

\item{index}{(\code{logical}) If \code{TRUE}, return the indexes of roots in 
\code{taxon_data} instead of \code{taxon_ids}}
}
\value{
\code{character}
}
\description{
Return the root taxa for a \code{\link{taxmap}} object. Can also be used to get the roots of
a subset of taxa.
}
\seealso{
Other taxmap taxonomy functions: \code{\link{obs}},
  \code{\link{subtaxa}}, \code{\link{supertaxa}}
}
