% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{unite_ex_data_3}
\alias{unite_ex_data_3}
\title{Example of UNITE fungal ITS data}
\format{An object of type \code{\link{taxmap}}}
\source{
\url{https://unite.ut.ee/}
}
\usage{
unite_ex_data_3
}
\description{
A dataset containing information from 500 sequences from the UNITE reference database.
}
\examples{
\dontrun{

file_path <- system.file("extdata", "unite_general_release.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
unite_ex_data_3 <- extract_taxonomy(sequences,
                                    regex = "^(.*)\\\\|(.*)\\\\|(.*)\\\\|.*\\\\|(.*)$",
                                    key = c(seq_name = "obs_info", seq_id = "obs_info",
                                            other_id = "obs_info", "class"),
                                    class_regex = "^(.*)__(.*)$",
                                    class_key = c(unite_rank = "taxon_info", "name"),
                                    class_sep = ";")
}

}
\keyword{datasets}
