% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writers.R
\name{write_mothur_taxonomy}
\alias{write_mothur_taxonomy}
\title{Write an imitation of the Mothur taxonomy file}
\usage{
write_mothur_taxonomy(obj, file,
  tax_names = obj$get_data("taxon_names")[[1]],
  ids = obj$get_data("sequence_id")[[1]],
  scores = obj$get_data("score")[[1]])
}
\arguments{
\item{obj}{A taxmap object}

\item{file}{(\code{character} of length 1) The file path to save the
sequence fasta file. This is optional.}

\item{tax_names}{(\code{character} named by taxon ids) The names of taxa}

\item{ids}{(\code{character} named by taxon ids) Sequence ids}

\item{scores}{TBD}
}
\description{
Attempts to save taxonomic information of a taxmap object in the
mothur `*.taxonomy` format. If the taxmap object was created using
\code{\link{parse_mothur_taxonomy}}, then it should be able to replicate the format
exactly with the default settings.
}
\details{
The output file has a format like:

\preformatted{
AY457915	Bacteria(100);Firmicutes(99);Clostridiales(99);Johnsone...
AY457914	Bacteria(100);Firmicutes(100);Clostridiales(100);Johnso...
AY457913	Bacteria(100);Firmicutes(100);Clostridiales(100);Johnso...
AY457912	Bacteria(100);Firmicutes(99);Clostridiales(99);Johnsone...
AY457911	Bacteria(100);Firmicutes(99);Clostridiales(98);Ruminoco...
}

or...

\preformatted{
AY457915	Bacteria;Firmicutes;Clostridiales;Johnsonella_et_rel.;J...
AY457914	Bacteria;Firmicutes;Clostridiales;Johnsonella_et_rel.;J...
AY457913	Bacteria;Firmicutes;Clostridiales;Johnsonella_et_rel.;J...
AY457912	Bacteria;Firmicutes;Clostridiales;Johnsonella_et_rel.;J...
AY457911	Bacteria;Firmicutes;Clostridiales;Ruminococcus_et_rel.;...
}
}
\seealso{
Other writers: \code{\link{write_greengenes}},
  \code{\link{write_rdp}},
  \code{\link{write_unite_general}}
}
\concept{writers}
