% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_qiime_biom}
\alias{parse_qiime_biom}
\title{Parse a BIOM output from QIIME}
\usage{
parse_qiime_biom(file, class_regex = "(.*)", class_key = "taxon_name")
}
\arguments{
\item{file}{(\code{character} of length 1) The file path to the input file.}

\item{class_regex}{A regular expression used to parse data in the taxon
names. There must be a capture group (a pair of parentheses) for each item
in \code{class_key}. See \code{\link[taxa]{parse_tax_data}} for examples of
how this works.}

\item{class_key}{(\code{character} of length 1) The identity of the capturing groups defined using
\code{class_regex}. The length of \code{class_key} must be equal to the number of capturing groups
specified in \code{class_regex}. Any names added to the terms will be used as column names in the
output. At least one \code{"taxon_name"} must be specified. Only \code{"info"} can be used multiple
times. Each term must be one of those described below: * \code{taxon_name}: The name of a taxon. Not
necessarily unique, but are interpretable by a particular \code{database}. Requires an internet
connection. * \code{taxon_rank}: The rank of the taxon. This will be used to add rank info into the
output object that can be accessed by \code{out$taxon_ranks()}. * \code{info}: Arbitrary taxon info you
want included in the output. Can be used more than once.}
}
\value{
A taxmap object
}
\description{
Parses a file in BIOM format from QIIME into a taxmap object.
This also seems to work with files from MEGAN.
I have not tested if it works with other BIOM files.
}
\details{
This function was inspired by the tutorial created by Geoffrey Zahn at 
http://geoffreyzahn.com/getting-your-otu-table-into-r/.
}
\seealso{
Other parsers: \code{\link{parse_dada2}},
  \code{\link{parse_edge_list}},
  \code{\link{parse_greengenes}},
  \code{\link{parse_mothur_tax_summary}},
  \code{\link{parse_mothur_taxonomy}},
  \code{\link{parse_newick}}, \code{\link{parse_phyloseq}},
  \code{\link{parse_phylo}}, \code{\link{parse_rdp}},
  \code{\link{parse_silva_fasta}},
  \code{\link{parse_ubiome}},
  \code{\link{parse_unite_general}}
}
\concept{parsers}
