% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_control_quality.R
\name{summarize_control_quality}
\alias{summarize_control_quality}
\title{Summarize the control quality of studies}
\usage{
summarize_control_quality(.df, ..., domains = TRUE)
}
\arguments{
\item{.df}{A data frame, usually the result of \code{\link[=metaconfoundr]{metaconfoundr()}}}

\item{...}{Boolean arguments to declare adequate control logic}

\item{domains}{Logical. Include the domains in the output? If \code{FALSE}, only
returns overall control quality.}
}
\value{
A tibble
}
\description{
\code{summarize_control_quality()} allows you to summarize how well studies
control for variables within one or more domains, and how well those domains
are controlled for overall. Each logical statement is a domain and can be
named.
}
\examples{

summary_df <- summarize_control_quality(
  metaconfoundr(ipi),
  Sociodemographics = `Maternal age` & `Race/ethnicity` & `Marital status`,
  Socioeconomics = `SES category` | Insurance & Education,
  "Reproductive Hx" = `Prior pregnancy outcome`
)

summary_df

summary_df \%>\%
  mc_trafficlight() +
  theme_mc() +
  facet_constructs() +
  geom_cochrane() +
  scale_fill_cochrane()

}
