#' IPI data
#'
#' These data represent 14 analyses (retrospective cohorts and sibling-matched
#' designs) to evaluate the association between short interpregnancy interval
#' (<6 months versus 18-23 months) and risk of preterm birth (<37 weeks
#' gestation) and the adequacy of confounder control (Petersen et al.). Adequacy
#' of confounder control was determined overall for each study as well as by
#' variable and construct (groupings of conceptually related variables).These
#' studies are a subset of studies originally identified in a systematic review
#' by Ahrens et al. to summarize associations between short interpregnancy
#' interval and a variety of perinatal outcomes in high-resource settings.
#'
#' @references Ahrens KA, Nelson H, Stidd RL, Moskosky S, Hutcheon JA. Short
#'   interpregnancy intervals and adverse perinatal outcomes in high-resource
#'   settings: An updated systematic review. Paediatr Perinat Epidemiol.
#'   2019;33(1):O25-O47.
#'
#' @references Petersen JM, Barrett M, Ahrens K, Murray EJ, Hogue C, Mumford S,
#'   Bryant Mantha A, Fox MP, Gadupudi S, Trinquart L. Confounder Matrix: A Tool
#'   to Assess Confounding Bias in Systematic Reviews of Observational Studies.
#'   2020
#'
#' @source Ahrens et al. (2019)
#'
#' @name ipi_data
"ipi"

#' @rdname ipi_data
"ipi_wide"

#' @rdname ipi_data
"ipi_metaanalysis"
