% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_rawdata.R
\name{strip_rawdata}
\alias{strip_rawdata}
\alias{strip_rawdata.list}
\alias{strip_rawdata.gamm}
\alias{strip_rawdata.bam}
\alias{strip_rawdata.gam}
\title{Strip rawdata from a generalized additive model}
\usage{
strip_rawdata(model, path = NULL, save_ranges = TRUE, ...)

\method{strip_rawdata}{list}(model, path = NULL, save_ranges = TRUE, ...)

\method{strip_rawdata}{gamm}(model, path = NULL, save_ranges = TRUE, ...)

\method{strip_rawdata}{bam}(model, path = NULL, save_ranges = TRUE, ...)

\method{strip_rawdata}{gam}(model, path = NULL, save_ranges = TRUE, ...)
}
\arguments{
\item{model}{A model fitted using \code{mgcv::gam}, \code{mgcv::bam},
\code{mgcv::gamm}, or \code{gamm4::gamm4}.}

\item{path}{Optional path in which to save the object as a \code{.rds} file.}

\item{save_ranges}{Logical specifying whether to save the ranges of each
variable used by the model. For numeric variables this amounts to the minimum
and maximum, and for factors all levels are saved. The values will be in the
list element \code{var.summary} of the returned object.}

\item{...}{Other arguments (not used).}
}
\value{
Model object with individual participant data removed.
}
\description{
This function removes all individual participant data from a generalized additive
model object, while keeping aggregated quantities. The resulting object can be
shared without exposing individual participant data.
}
\details{
Thin plate regression splines (\code{bs='tp'} and \code{bs='ts'}) and Duchon splines \code{bs='ds'}
are currently not supported, since for these splines \code{mgcv}
requires the unique values of the explanatory variables for each smooth term for the \code{predict}
method to work. Future updates to this package will fix this.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Strip rawdata from list object returned by gamm4

\item \code{gamm}: Strip rawdata from gamm object

\item \code{bam}: Strip rawdata from gam object

\item \code{gam}: Strip rawdata from gam object
}}

\examples{
library(metagam)
library(mgcv)

## Create 5 datasets
set.seed(1234)
datasets <- lapply(1:5, function(x) gamSim(scale = 5, verbose = FALSE))

## Fit a GAM in each dataset, then use strip_rawdata() to remove
## individual participant data
models <- lapply(datasets, function(dat){
  ## This uses the gam() function from mgcv
  model <- gam(y ~ s(x0, bs = "cr") + s(x1, bs = "cr") + s(x2, bs = "cr"), data = dat)
  ## This uses strip_rawdata() from metagam
  strip_rawdata(model)
})

## Next, we meta-analyze the models.
## It is often most convenient to analyze a single term at a time. We focus on s(x1).
meta_analysis <- metagam(models, terms = "s(x1)", grid_size = 30)

## We can print some information
summary(meta_analysis)

## We can plot the fit
plot(meta_analysis)

## Meta analysis can also be performed in parallel, using future
\dontrun{
  library(future)
  plan(multisession, workers = 2)
  meta_analysis <- metagam(models, terms = "s(x1)", grid_size = 30)
  plan("default")
}
}
