% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_extractDetectedPoints.R
\name{figure_extractDetectedPoints}
\alias{figure_extractDetectedPoints}
\title{Extracts data points from a detected image.}
\usage{
figure_extractDetectedPoints(aDetectedPlot, xAxis = NULL, yAxis = NULL,
  X_min = NULL, X_max = NULL, Y_min = NULL, Y_max = NULL,
  summarize = TRUE)
}
\arguments{
\item{aDetectedPlot}{A binary figure image with detected points (an 
\code{EBImage} object).  See: \code{\link{figure_detectAllPoints}}}

\item{xAxis}{A binary figure image with detected X-axis (an \code{EBImage}
object).  See: \code{\link{figure_detectAxis}}.}

\item{yAxis}{A binary figure image with detected Y-axis (an \code{EBImage} 
object).  See: \code{\link{figure_detectAxis}}.}

\item{X_min}{The minimum value of X reported on the figure X-axis.}

\item{X_max}{The maximum value of X reported on the figure X-axis.}

\item{Y_min}{The minimum value of Y reported on the figure Y-axis.}

\item{Y_max}{The maximum value of Y reported on the figure Y-axis.}

\item{summarize}{When \code{TRUE} returns a summary of the regression 
parameters (intercept + slope * X), R-squared, Pearson's product moment
correlation coefficient (r), and its variance (var_r) and sample size (N).}
}
\value{
A data frame with the extracted X and Y values.
}
\description{
Extracts raw X and Y data from the points detected in a scatter-plot figure.
}

