% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlf_ae_listing.R
\name{tlf_ae_listing}
\alias{tlf_ae_listing}
\title{Specific adverse events table}
\usage{
tlf_ae_listing(
  outdata,
  footnotes = NULL,
  source = NULL,
  col_rel_width = NULL,
  text_font_size = 9,
  orientation = "landscape",
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{A outdata list created by \code{\link[=prepare_ae_listing]{prepare_ae_listing()}}.}

\item{footnotes}{A character vector of table footnotes.}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
RTF file and source dataset for AE listing.
}
\description{
Specific adverse events table
}
\examples{
library(r2rtf)
library(metalite)

meta <- meta_ae_example()
prepare_ae_listing(meta, "ae_listing", "apat", "wk12", "ser") |>
  tlf_ae_listing(
    footnotes = "footnote1",
    source = "Source:  [CDISCpilot: adam-adsl; adae]",
    path_outdata = tempfile(fileext = ".Rdata"),
    path_outtable = tempfile(fileext = ".rtf")
  )
}
