% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_ae_specific_subgroup.R
\name{prepare_ae_specific_subgroup}
\alias{prepare_ae_specific_subgroup}
\title{Prepare datasets for AE specific subgroup analysis}
\usage{
prepare_ae_specific_subgroup(
  meta,
  population,
  observation,
  parameter,
  subgroup_var,
  subgroup_header = c(meta$population[[population]]$group, subgroup_var),
  components = c("soc", "par"),
  display_subgroup_total = TRUE
)
}
\arguments{
\item{meta}{A metadata object created by metalite.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{observation}{A character value of observation term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{subgroup_var}{A character value of subgroup variable name in
observation data saved in \code{meta$data_observation}.}

\item{subgroup_header}{A character vector for column header hierarchy.
The first element will be the first level header and the second element
will be second level header.}

\item{components}{A character vector of components name.}

\item{display_subgroup_total}{Logical. Display total column for
subgroup analysis or not.}
}
\value{
A list of analysis datasets needed for AE specific subgroup analysis.
}
\description{
Prepare datasets for AE specific subgroup analysis
}
\examples{
meta <- meta_ae_example()
prepare_ae_specific_subgroup(meta, "apat", "wk12", "rel", subgroup_var = "SEX")$data
}
