% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_exp_duration.R
\name{format_exp_duration}
\alias{format_exp_duration}
\title{Format Exposure Duration Analysis}
\usage{
format_exp_duration(
  outdata,
  display_col = c("n", "prop", "n_cum", "prop_cum", "total"),
  digits_prop = 1,
  display_stat = c("mean", "sd", "se", "median", "q1 to q3", "range")
)
}
\arguments{
\item{outdata}{A metadata object created by \code{\link[=prepare_sl_summary]{prepare_sl_summary()}}.}

\item{display_col}{Column wants to display on the table.
"n_cum", "prop_cum" can additionally be selected.
\itemize{
\item \code{n_cum}: Number of subjects created by \code{extend_exp_duration()}.
\item \code{prop_cum}: Proportion of subjects created by \code{extend_exp_duration()}.
}}

\item{digits_prop}{Number of digits for proportion columns.}

\item{display_stat}{A vector of statistics term name.
The term name could be selected from
\code{c("mean", "sd", "se", "median", "q1 to q3", "range", "q1", "q3", "min", "max")}.}
}
\value{
A list of analysis raw datasets.
}
\description{
Format Exposure Duration Analysis
}
\examples{
meta <- meta_sl_exposure_example()

meta |>
  prepare_exp_duration(population = "apat", parameter = "expdur") |>
  format_exp_duration(display_col = c("n", "prop", "total"))
}
