% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam_mapping.R
\name{adam_mapping}
\alias{adam_mapping}
\title{Construct ADaM mappings}
\usage{
adam_mapping(
  name,
  id = NULL,
  group = NULL,
  var = NULL,
  subset = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{name}{A character value of term name.
The term name is used as key to link information.}

\item{id}{A character value of subject identifier variable name
in an ADaM dataset.}

\item{group}{A character vector of group variable names in an ADaM dataset.}

\item{var}{A character vector of useful variable names in an ADaM dataset.}

\item{subset}{An expression to identify analysis records.
See \code{\link[base:subset]{base::subset()}}.}

\item{label}{A character value of analysis label.}

\item{...}{Additional variables.}
}
\value{
A list with class \code{adam_mapping}.
Components of the list are either quosures or constants.
}
\description{
ADaM mappings describe how variables and meta information in the ADaM data
are mapped to standardized term.
}
\details{
The design is inspired by \code{ggplot2::aes()}.
}
\examples{
adam_mapping(
  name = "apat",
  id = "USUBJID",
  group = "TRT01A",
  subset = TRTFL == "Y",
  label = "All Participants as Treated"
)
}
