% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riley.r
\name{plot.riley}
\alias{plot.riley}
\title{Plot the summary of the bivariate model from Riley et al. (2008).}
\usage{
\method{plot}{riley}(x, title, sort = "asc", xlim, refline, ...)
}
\arguments{
\item{x}{An object of class \code{riley}}

\item{title}{Title of the forest plot}

\item{sort}{By default, studies are ordered by ascending effect size (\code{sort="asc"}). For study ordering by descending
effect size, choose \code{sort="desc"}. For any other value, study ordering is ignored.}

\item{xlim}{The \code{x} limits \code{(x1, x2)} of the forest plot}

\item{refline}{Optional numeric specifying a reference line}

\item{\dots}{Additional parameters for generating forest plots}
}
\description{
Generates a forest plot for each outcome of the bivariate meta-analysis.
}
\examples{
data(Scheidler)

#Perform the analysis
fit <- riley(Scheidler[which(Scheidler$modality==1),])
plot(fit)

require(ggplot2)
plot(fit, sort="none", theme=theme_gray())

}
\references{
Riley RD, Thompson JR, Abrams KR. An alternative model for bivariate random-effects meta-analysis 
when the within-study correlations are unknown. \emph{Biostatistics} 2008; \bold{9}: 172--186.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{forest}
