% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamem.R
\name{print.gamem}
\alias{print.gamem}
\title{Print an object of class gamem}
\usage{
\method{print}{gamem}(x, export = FALSE, file.name = NULL, digits = 4, ...)
}
\arguments{
\item{x}{An object fitted with the function \code{\link[=gamem]{gamem()}} .}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported to
the working directory}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print the \code{gamem} object in two ways. By default, the results are shown
in the R console. The results can also be exported to the directory.
}
\examples{
\donttest{
library(metan)
alpha <- gamem(data_alpha,
  gen = GEN,
  rep = REP,
  block = BLOCK,
  resp = YIELD
)

print(alpha)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
