% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter.R
\name{scatter_data_frame}
\alias{scatter_data_frame}
\title{Scatterplot Function for Data Frame}
\usage{
scatter_data_frame(x, yvar, xvar, groups = NULL, facets = NULL,
  log = getOption("metaplot_log", FALSE), ylog = getOption("metaplot_ylog",
  log), xlog = getOption("metaplot_xlog", log),
  crit = getOption("metaplot_crit", 1.3), yref = getOption("metaplot_ref",
  metaplot_ref), xref = getOption("metaplot_ref", metaplot_ref),
  ylab = getOption("metaplot_lab", axislabel),
  xlab = getOption("metaplot_lab", axislabel),
  ysmooth = getOption("metaplot_ysmooth", FALSE),
  xsmooth = getOption("metaplot_xsmooth", FALSE),
  iso = getOption("metaplot_iso", FALSE),
  na.rm = getOption("metaplot_na.rm", TRUE),
  aspect = getOption("metaplot_aspect", 1),
  auto.key = getOption("metaplot_auto.key", NULL),
  keycols = getOption("metaplot_keycols", NULL),
  as.table = getOption("metaplot_scatter_as.table", TRUE),
  prepanel = getOption("metaplot_scatter_prepanel", NULL),
  scales = getOption("metaplot_scatter_scales", NULL),
  panel = getOption("metaplot_scatter_panel", scatter_panel),
  colors = getOption("metaplot_colors", NULL),
  symbols = getOption("metaplot_symbols", NULL),
  points = getOption("metaplot_points", TRUE),
  lines = getOption("metaplot_lines", FALSE),
  main = getOption("metaplot_main", NULL), sub = getOption("metaplot_sub",
  NULL), ...)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{character: y variable(s)}

\item{xvar}{character: x variable}

\item{groups}{optional grouping variable; ignored if more than one \code{yvar}}

\item{facets}{optional conditioning variables}

\item{log}{a default shared by \code{ylog} and \code{xlog}}

\item{ylog}{log transform y axis (auto-selected if NA)}

\item{xlog}{log transform x axis (auto-selected if NA)}

\item{crit}{if ylog or xlog missing, log transform if mean/median ratio for non-missing values is greater than crit}

\item{yref}{reference line from y axis; can be function(x = x, var = yvar, ...)}

\item{xref}{reference line from x axis; can be function(x = x, var = xvar, ...)}

\item{ylab}{y axis label; can be function(x = x, var = yvar, log = ylog, ..)}

\item{xlab}{x axis label; can be function(x = x, var = xvar, log = xlog, ..)}

\item{ysmooth}{supply loess smooth of y on x}

\item{xsmooth}{supply loess smmoth of x on y}

\item{iso}{plot line of unity (auto-selected if NA)}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{aspect}{passed to \code{\link[lattice]{xyplot}}}

\item{auto.key}{passed to \code{\link[lattice]{xyplot}}}

\item{keycols}{number of auto.key columns}

\item{as.table}{passed to \code{\link[lattice]{xyplot}}}

\item{prepanel}{passed to \code{\link[lattice]{xyplot}} (guessed if NULL)}

\item{scales}{passed to \code{\link[lattice]{xyplot}} (guessed if NULL)}

\item{panel}{name or definition of panel function}

\item{colors}{replacements for default colors in group order}

\item{symbols}{replacements for default symbols in group order}

\item{points}{whether to plot points for each group: logical, or alpha values between 0 and 1}

\item{lines}{whether to plot lines for each group: logical, or alpha values between 0 and 1}

\item{main}{character, or a function of x, yvar, xvar, groups, facets, and log}

\item{sub}{character, or a function of x, yvar, xvar, groups, facets, and log}

\item{...}{passed to \code{\link{region}}}
}
\description{
Scatterplot function for class 'data.frame'.
}
\examples{
library(magrittr)
library(dplyr)
attr(Theoph$conc,'label') <- 'theophylline concentration'
attr(Theoph$conc,'guide') <- 'mg/L'
attr(Theoph$Time,'label') <- 'time'
attr(Theoph$Time,'guide') <- 'h'
attr(Theoph$Subject,'guide') <- '////'
scatter_data_frame(Theoph, 'conc', 'Time')
scatter_data_frame(Theoph, 'conc','Time', 'Subject')
scatter_data_frame(Theoph, 'conc','Time', facets = 'Subject')
scatter_data_frame(Theoph \%>\% filter(conc > 0), 'conc','Time', 'Subject',ylog = TRUE, yref = 5)
scatter_data_frame(Theoph, 'conc','Time', 'Subject',ysmooth = TRUE)
scatter_data_frame(Theoph, 'conc','Time', 'Subject',ysmooth = TRUE,global = TRUE)
scatter_data_frame(Theoph, 'conc','Time', conf = TRUE, loc = 3, yref = 6)
scatter_data_frame(Theoph, 'conc','Time', conf = TRUE, loc = 3, yref = 6)
}
\seealso{
\code{\link{scatter_panel}}

Other bivariate plots: \code{\link{iso_prepanel}},
  \code{\link{metaplot.data.frame}},
  \code{\link{scatter.data.frame}}, \code{\link{scatter}}

Other metaplot: \code{\link{boxplot_data_frame}},
  \code{\link{corsplom_data_frame}},
  \code{\link{densplot_data_frame}}, \code{\link{metaplot}}

Other scatter: \code{\link{scatter.data.frame}},
  \code{\link{scatter_panel}}, \code{\link{scatter}}
}
