% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{categorical_panel}
\alias{categorical_panel}
\title{Panel Function for Metaplot Categorical Plot}
\usage{
categorical_panel(x, y, groups, bivariate = TRUE,
  loc = getOption("metaplot_loc", 5), msg = getOption("metaplot_msg",
  "tilestats"), tex = getOption("metaplot_tex", 0.9),
  cex = getOption("metaplot_categorical_panel_cex", 1),
  pch = getOption("metaplot_categorical_pch", 22),
  rot = getOption("metaplot_categorical_rot", c(90, 0)), subscripts, ...)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{groups}{optional grouping item}

\item{bivariate}{whether to create y axis}

\item{loc}{where to print statistics in a tile}

\item{msg}{a function of x and y to print text in a tile}

\item{tex}{tile expansion: scale factor for reducing each tile size relative to full size (<= 1)}

\item{cex}{expansion for msg text}

\item{pch}{symbol character for legend}

\item{rot}{rotation for axis labels; can be length 2 for y and x axes, respectively}

\item{subscripts}{subscripts of the original data for this panel}

\item{...}{passed to \code{link[lattice]{panel.superpose}}}
}
\description{
Default panel function for categorical_data_frame. Implements a simple mosaic plot.
}
\seealso{
\code{\link{tilestats}}

\code{\link{categorical.data.frame}}

Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_label}},
  \code{\link{diag_pin}}, \code{\link{iso_prepanel}},
  \code{\link{metaplot_ref}}, \code{\link{panel_tile}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}

Other categorical: \code{\link{categorical.data.frame}},
  \code{\link{categorical_data_frame}},
  \code{\link{categorical}}, \code{\link{panel_tile}}
}
