% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{densplot.data.frame}
\alias{densplot.data.frame}
\title{Densplot Method for Data Frame}
\usage{
\method{densplot}{data.frame}(x, ..., fun = getOption("metaplot_densplot",
  "densplot_data_frame"), verbose = metOption("metaplot_verbose_densplot",
  FALSE))
}
\arguments{
\item{x}{data.frame}

\item{...}{passed to fun}

\item{fun}{plotting function}

\item{verbose}{generate messages describing process}
}
\description{
Plot density for object of class 'data.frame'. Parses arguments and generates the call: fun(x, xvar, groups, facets,...).
}
\examples{
densplot(Theoph, conc, grid = TRUE )
densplot(Theoph, conc, grid = TRUE, gg = TRUE )
densplot(Theoph, conc, Subject )
densplot(Theoph, conc, , Subject )
densplot(Theoph, conc, , Subject, gg = TRUE, scales = 'free_y' )
attr(Theoph,'title') <- 'Theophylline'
densplot(Theoph, conc, main= function(x,...)attr(x,'title'))
densplot(Theoph, conc, sub= function(x,...)attr(x,'title'))
}
\seealso{
Other univariate plots: \code{\link{dens_panel}},
  \code{\link{densplot_data_frame}},
  \code{\link{densplot}},
  \code{\link{metaplot.data.frame}},
  \code{\link{panel.meta_densityplot}}

Other densplot: \code{\link{densplot_data_frame}},
  \code{\link{densplot}}

Other methods: \code{\link{axislabel.data.frame}},
  \code{\link{boxplot.data.frame}},
  \code{\link{categorical.data.frame}},
  \code{\link{corsplom.data.frame}},
  \code{\link{metaplot.data.frame}},
  \code{\link{pack.data.frame}},
  \code{\link{plot.metaplot_gtable}},
  \code{\link{print.metaplot_gtable}},
  \code{\link{scatter.data.frame}},
  \code{\link{unpack.data.frame}}
}
