% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_factor}
\alias{as_factor}
\title{Coerce to Factor using Encoding if Present}
\usage{
as_factor(x)
}
\arguments{
\item{x}{vector or factor}
}
\value{
factor
}
\description{
Coerces to factor, blending levels with encoding, if present. Vectors without encodings (or with empty encodings) acquire levels equal to \code{unique(x)} (notice that storage order controls presentation order). Vectors with non-empty encodings are decoded after harmonizing the encoding and the actual data. Factors with encodings defer to order and display value of the encoding as much as possible.  Missing levels are supplied.  Unused levels are removed. Other attributes beside 'class' and 'levels' are preserved.
}
\examples{
library(magrittr)
foo <- c(1, 2, NA, 4, 5)
as_factor(foo)
as_factor(factor(foo))
as_factor(as.factor(foo))
as_factor(structure(foo, guide = '....'))
as_factor(structure(foo, guide = '//5//'))
as_factor(structure(foo, guide = '//5/bar//'))
as_factor(structure(foo, guide = '//5/bar//6/baz//'))
as_factor(structure(factor(foo), guide = '//5/bar//'))
as_factor(structure(factor(foo), guide = '//5/bar//')) \%>\% sort
as_factor(structure(factor(foo), guide = '....'))
as_factor(structure(factor(foo), guide = '//1/bar//5/bar//'))


}
