% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{metOption}
\alias{metOption}
\title{Get Metaplot Option with Partial Matching}
\usage{
metOption(x, default = NULL)
}
\arguments{
\item{x}{a character string holding an option name}

\item{default}{the value returned if option is not set}
}
\description{
Gets a metaplot option value from  the named list \code{getOption('metaplot')}.
If an exact match is not found, trailing elements of x, separated by underscore,
are removed one at a time in search of a partial match. Thus 'ref.col' will match
for 'ref.col_dens' and 'ref.col_scatter' if neither of these is set (allowing
selective override). However, global' will never match 'global.col'.
}
\details{
If x is missing a list of all metaplot options is returned.
}
\examples{

library(magrittr)
library(dplyr)
library(csv)
x <- as.csv(system.file(package = 'metaplot', 'extdata/theoph.csv'))
x \%<>\% pack

multiplot(
x \%>\% metaplot(conc, gg = F),
x \%>\% metaplot(conc, time, gg = F),
x \%>\% metaplot(conc, arm, gg = F),
x \%>\% metaplot(conc, arm,  gg = T)
)

# Add a reference line at 9 mg/L
x$conc \%<>\% structure(reference = 9)

# Make the reference line green universally.
setOption(ref_col = 'green')

# Make the reference line orange for density plots
setOption(ref_col_dens = 'orange')

multiplot(
x \%>\% metaplot(conc, gg = F),
x \%>\% metaplot(conc, time, gg = F),
x \%>\% metaplot(conc, arm, gg = F),
x \%>\% metaplot(conc, arm,  gg = T)
)

# Restore defaults
# setOption() # clears all metaplot options
setOption(ref_col = NULL)
setOption(ref_col_dens = NULL)
}
\seealso{
\code{\link{getOption}} \code{\link{setOption}}
}
