% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings_df.R
\name{random_removal}
\alias{random_removal}
\title{Generate random removal sequence}
\usage{
random_removal(
  columns,
  min_removed_inputs,
  max_removed_inputs,
  dropout_dist = "exponential"
)
}
\arguments{
\item{columns}{Columns of the settings_df that are passed in}

\item{min_removed_inputs}{The smallest number of input data frames that may
be randomly removed.}

\item{max_removed_inputs}{The largest number of input data frames that may be
randomly removed.}

\item{dropout_dist}{Indication of how input data frames should be dropped.
can be "none" (no dropout), "uniform" (uniformly draw number between min
and max removed inputs), or "exponential" (like uniform, but using an
exponential distribution; default).}
}
\value{
inclusions_df data frame that can be rbind'ed to the settings_df
}
\description{
Helper function to contribute to rows within the settings data frame. Number
of columns removed follows a uniform or exponential probability
distribution.
}
