% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{include_meta}
\alias{include_meta}
\title{Include Metadata Tags in HTML Document}
\usage{
include_meta(.meta)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}
}
\value{
An \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} containing the metadata tags to be
included in the \verb{<head>} of the HTML document.
}
\description{
Use \code{include_meta()} to explicitly declare the \code{\link[=meta]{meta()}} tags as an HTML
dependency. In general, this is not required when knitting to an HTML
document. This function explicitly attaches an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}
and may work in some unusual cases.
}
\examples{
meta() \%>\%
  meta_name("github-repo" = "gadenbuie/metathis") \%>\%
  include_meta()

}
\seealso{
Other meta_actions: 
\code{\link{write_meta}()}
}
\concept{meta_actions}
