% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolationgrid.R, R/interpolationpixels.R,
%   R/interpolationpoints.R
\name{interpolationgrid}
\alias{interpolationgrid}
\alias{interpolationpixels}
\alias{interpolationpoints}
\title{Interpolate daily meteorology over a landscape}
\usage{
interpolationgrid(
  object,
  grid,
  dates = NULL,
  exportFile = NULL,
  exportFormat = "netCDF",
  add = FALSE,
  overwrite = FALSE,
  verbose = TRUE
)

interpolationpixels(
  object,
  pixels,
  dates = NULL,
  exportFile = NULL,
  exportFormat = "netCDF",
  add = FALSE,
  overwrite = FALSE,
  verbose = TRUE
)

interpolationpoints(
  object,
  points,
  dates = NULL,
  export = FALSE,
  exportDir = getwd(),
  exportFile = NULL,
  exportFormat = "meteoland/txt",
  metadataFile = "MP.txt",
  verbose = TRUE
)
}
\arguments{
\item{object}{An object of class
\code{\link{MeteorologyInterpolationData-class}}.}

\item{grid}{An object of class \code{\link{SpatialGridTopography-class}}
representing the target landscape.}

\item{dates}{An object of class \code{\link{Date}}. If this is \code{NULL}
then all dates in \code{object} are processed.}

\item{exportFile}{Output file for interpolated meteorology data (netCDF
format).}

\item{exportFormat}{Export format for meteorological data (see
\code{\link{writemeteorologypoint}}).  If format is \code{"meteoland/txt"},
\code{"meteoland/rds"}, \code{"castanea/txt"} or \code{"castanea/rds"} the
function tries to write one file per point in \code{exportDir}. If format is
\code{"netCDF"} the function will write data to a single file specified by
\code{exportFile}.}

\item{add}{Boolean flag to indicate that NetCDF exists and data should be
added/replaced.}

\item{overwrite}{Boolean flag to force overwriting an existing NetCDF.}

\item{verbose}{Boolean flag to print process information.}

\item{pixels}{An object of class \code{\link{SpatialPixelsTopography-class}}
representing the target landscape.}

\item{points}{An object of class
\code{\link{SpatialPointsTopography-class}}.}

\item{export}{If \code{export = FALSE} the result of interpolation is stored
in memory. Otherwise the result is written in the disk (using the format
specified in \code{exportFormat}).}

\item{exportDir}{Output directory for interpolated meteorology data files
(txt/rds format).}

\item{metadataFile}{The name of the ascii text file that will store the meta
data describing all written files.}
}
\value{
If \code{export = FALSE}, function \code{interpolationpoints}
returns an object of \code{\link{SpatialPointsMeteorology-class}}. If
\code{export = TRUE} files and written in the disk. For text/rds format the
function returns an object of class
\code{SpatialPointsDataFrame} containing point meta data.

If \code{export = FALSE}, function \code{interpolationpixels} returns an
object of \code{\link{SpatialPixelsMeteorology-class}}, or an object of
\code{SpatialPixelsDataFrame} if a single date is interpolated.
If \code{export = TRUE}, the function writes the results in a NetCDF.

If \code{export = FALSE}, function \code{interpolationgrid} returns an
object of \code{\link{SpatialGridMeteorology-class}}, or an object of
\code{SpatialGridDataFrame} if a single date is interpolated.
If \code{export = TRUE}, the function writes the results in files and a
\code{data.frame} with columns 'dir' and 'filename' is returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Functions to interpolate meteorological data for spatial locations (at
points, grid pixels or full grids) using an object of class
\code{\link{MeteorologyInterpolationData-class}}.
}
\details{
CRS projection needs to be defined for both \code{object} and
\code{points}/\code{pixels}/\code{grid}. If CRS projection is different
between \code{object} and \code{points}/\code{pixels}/\code{grid}, the
function transforms the coordinates of
\code{points}/\code{pixels}/\code{grid} to adapt them to the CRS of
\code{object}.
}
\section{Functions}{
\itemize{
\item \code{interpolationgrid()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{interpolationpixels()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

}}
\references{
Thornton, P.E., Running, S.W., White, M. A., 1997. Generating
surfaces of daily meteorological variables over large regions of complex
terrain. J. Hydrol. 190, 214–251. doi:10.1016/S0022-1694(96)03128-9.

De Caceres M, Martin-StPaul N, Turco M, Cabon A, Granda V (2018) Estimating
daily meteorological data and downscaling climate models over landscapes.
Environmental Modelling and Software 108: 186-196.
}
\seealso{
\code{\link{penman}}, \code{\link{SpatialPointsTopography-class}},
\code{\link{SpatialGridTopography}}, \code{\link{SpatialPixelsTopography}},
\code{\link{MeteorologyInterpolationData}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
