% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_utils.R
\name{precipitation_rainfall_erosivity}
\alias{precipitation_rainfall_erosivity}
\title{Precipitation rainfall erosivity}
\usage{
precipitation_rainfall_erosivity(
  meteo_data,
  longitude,
  scale = c("month", "year"),
  average = TRUE
)
}
\arguments{
\item{meteo_data}{A meteo tibble as with the dates and meteorological variables
as returned by \code{\link{interpolate_data}} in the "interpolated_data"
column.}

\item{longitude}{Longitude in degrees.}

\item{scale}{Character, either 'month' or 'year'. Default to 'month'}

\item{average}{Boolean flag to calculate multi-year averages before applying
MedREM's formula.}
}
\value{
A vector of values for each month (in MJ·mm·ha-1·h-1·month-1) or each
year (in MJ·mm·ha-1·h-1·yr-1), depending on the scale
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Function \code{precipitation_rainfall_erosivity()} calculates a multi-year
average of monthly rainfall erosivity using the MedREM model proposed by
Diodato and Bellochi (2010) for the Mediterranean area (see also Guerra et
al. 2016).
}
\details{
MedREM model is: Rm = b0·P·sqrt(d)·(alpha + b1*longitude), where P is
accumulated precipitation and d is maximum daily precipitation. Parameters
used for the MedREM model are b0 = 0.117, b1 = -0.015, alpha = 2. Note that
there is a mistake in Guerra et al. (2016) regarding parameters b1 and a.
}
\examples{
\donttest{
interpolated_example <-
  interpolate_data(points_to_interpolate_example, meteoland_interpolator_example)

precipitation_rainfall_erosivity(
  meteo_data = interpolated_example$interpolated_data[[1]],
  longitude = 2.32,
  scale = "month",
  average = TRUE
)
}

}
\references{
Diodato, N., Bellocchi, G., 2010. MedREM, a rainfall erosivity
model for the Mediterranean region. J. Hydrol. 387, 119–127,
doi:10.1016/j.jhydrol.2010.04.003.

Guerra CA, Maes J, Geijzendorffer I, Metzger MJ (2016) An assessment of soil
erosion prevention by vegetation in Mediterranean Europe: Current trends of
ecosystem service provision. Ecol Indic 60:213–222. doi:
10.1016/j.ecolind.2015.06.043.
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF.

\enc{Víctor}{Victor} Granda \enc{García}{Garcia}, CREAF.
}
