% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleUnivNMoE.R
\name{sampleUnivNMoE}
\alias{sampleUnivNMoE}
\title{Draw a sample from a normal mixture of linear experts model.}
\usage{
sampleUnivNMoE(alphak, betak, sigmak, x)
}
\arguments{
\item{alphak}{The parameters of the gating network. \code{alphak} is a matrix of
size \emph{(q + 1, K - 1)}, with \emph{K - 1}, the number of regressors
(experts) and \emph{q} the order of the logistic regression}

\item{betak}{Matrix of size \emph{(p + 1, K)} representing the regression
coefficients of the experts network.}

\item{sigmak}{Vector of length \emph{K} giving the standard deviations of
the experts network.}

\item{x}{A vector og length \emph{n} representing the inputs (predictors).}
}
\value{
A list with the output variable \code{y} and statistics.
\itemize{
\item \code{y} Vector of length \emph{n} giving the output variable.
\item \code{zi} A vector of size \emph{n} giving the hidden label of the
expert component generating the i-th observation. Its elements are
\eqn{zi[i] = k}, if the i-th observation has been generated by the
k-th expert.
\item \code{z} A matrix of size \emph{(n, K)} giving the values of the binary
latent component indicators \eqn{Z_{ik}}{Zik} such that
\eqn{Z_{ik} = 1}{Zik = 1} iff \eqn{Z_{i} = k}{Zi = k}.
\item \code{stats} A list whose elements are:
\itemize{
\item \code{Ey_k} Matrix of size \emph{(n, K)} giving the conditional
expectation of Yi the output variable given the value of the
hidden label of the expert component generating the ith observation
\emph{zi = k}, and the value of predictor \emph{X = xi}.
\item \code{Ey} Vector of length \emph{n} giving the conditional expectation
of Yi given the value of predictor \emph{X = xi}.
\item \code{Vary_k} Vector of length \emph{k} representing the conditional
variance of Yi given \emph{zi = k}, and \emph{X = xi}.
\item \code{Vary} Vector of length \emph{n} giving the conditional expectation
of Yi given \emph{X = xi}.
}
}
}
\description{
Draw a sample from a normal mixture of linear experts model.
}
\examples{
n <- 500 # Size of the sample
alphak <- matrix(c(0, 8), ncol = 1) # Parameters of the gating network
betak <- matrix(c(0, -2.5, 0, 2.5), ncol = 2) # Regression coefficients of the experts
sigmak <- c(1, 1) # Standard deviations of the experts
x <- seq.int(from = -1, to = 1, length.out = n) # Inputs (predictors)

# Generate sample of size n
sample <- sampleUnivNMoE(alphak = alphak, betak = betak, sigmak = sigmak, x = x)

# Plot points and estimated means
plot(x, sample$y, pch = 4)
lines(x, sample$stats$Ey_k[, 1], col = "blue", lty = "dotted", lwd = 1.5)
lines(x, sample$stats$Ey_k[, 2], col = "blue", lty = "dotted", lwd = 1.5)
lines(x, sample$stats$Ey, col = "red", lwd = 1.5)
}
