#' @title import_apsim_out
#' @description Function to import *.out files generated by APSIM Classic.
#' @note Note: It imports one file at a time.
#' @param filepath Argument to specify the location path to the *.out file.
#' @return Element of class `data.frame`.
#' @details This function will generate a data frame object from an APSIM Classic *.out file.
#' @examples 
#' \donttest{
#' ## See [documentation](https://adriancorrendo.github.io/metrica/index.html)
#' }
#' @rdname import_apsim_out
#' @importFrom utils read.delim
#' @seealso 
#'  \code{\link[apsimx]{read_apsim}}
#' @export 

import_apsim_out <- function(filepath){
  uppersection <- utils::read.delim(filepath, sep = "",skip = 2,nrows = 1)
  
  COLNAMES <- colnames(uppersection)
  UNITY <- unlist(lapply(uppersection, as.character))
  HEADER <- mapply(function(x,y){paste(x,y)},COLNAMES,UNITY, SIMPLIFY = FALSE)
  
  
  dataframe <- utils::read.delim(filepath,sep = "",skip = 3,na.strings = c("?"),dec = ".")
  colnames(dataframe) <- HEADER
  
  return(dataframe)
}
