% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSE.R
\name{RMSE}
\alias{RMSE}
\title{Root Mean Squared Error (RMSE)}
\usage{
RMSE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the RMSE for a continuous predicted-observed dataset.
}
\details{
The RMSE is one of the most widely used error metrics in literature to
evaluate prediction performance. It measures general agreement, being sensitive to
both lack of precision and lack of accuracy. It is simply the square root of
the Mean Squared Error (MSE). Thus, it presents the same units as the variable of
interest, facilitating the interpretation. It goes from 0 to infinity. The lower
the value the better the prediction performance. Its counterpart is being very
sensitive to outliers.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RMSE(obs = X, pred = Y)
}
}
