% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_lambda.R
\name{lambda}
\alias{lambda}
\title{Duveiller's Agreement Coefficient}
\usage{
lambda(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the agreement coefficient (lambda) suggested by
Duveiller et al. (2016) for a continuous predicted-observed dataset.
}
\details{
lambda measures both accuracy and precision. It is normalized, dimensionless,
bounded (-1;1), and symmetric (invariant to predicted-observed orientation).
lambda is equivalent to CCC when r is greater or equal to 0. The closer to 1 the better.
Values towards zero indicate low correlation between observations and predictions.
Negative values would indicate a negative relationship between predicted and observed.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
lambda(obs = X, pred = Y)
}
}
\references{
Duveiller et al. (2016).
Revisiting the concept of a symmetric index of agreement for continuous datasets.
\emph{Sci. Rep. 6, 1-14.} \doi{10.1038/srep19401}
}
