% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_multiple_repos_metrics}
\alias{get_multiple_repos_metrics}
\title{Retrieve metrics for a list of repos}
\usage{
get_multiple_repos_metrics(
  repo_names = NULL,
  token = NULL,
  data_format = "dataframe",
  time_course = FALSE
)
}
\arguments{
\item{repo_names}{a character vector of repositories you'd like to collect metrics from.}

\item{token}{You can provide the Personal Access Token key directly or this function will attempt to grab a PAT that was stored using the `authorize("github")` function}

\item{data_format}{Default is to return a curated data frame. However if you'd like to see the raw information returned from GitHub set format to "raw".}

\item{time_course}{Should the time course data be collected or only the summary metrics?}
}
\value{
Information regarding a Github account
}
\description{
This is a function to get metrics for a list of repos. You can provide an owner and attempt retrieve all repositories from a
particular organization, or you can provide a character vector of repositories like "
}
\examples{
\dontrun{

authorize("github")

repo_names <- c("fhdsl/metricminer", "jhudsl/OTTR_Template")
some_repos_metrics <- get_multiple_repos_metrics(repo_names = repo_names)

some_repos_metrics <- get_multiple_repos_metrics(repo_names = repo_names, time_course = TRUE)
}

}
