% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-destination.R
\name{rail_destination}
\alias{rail_destination}
\title{Rail Station to Station Information}
\format{
A tibble 1 row per  with  variables:
\describe{
\item{SourceStation}{Origin station code. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{DestinationStation}{Destination station code. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{CompositeMiles}{Average of distance traveled between two stations and
straight-line distance (as used for WMATA fare calculations). For more
details, please refer to WMATA's \href{https://www.wmata.com/about/records/public_docs/upload/Tariff-on-Fares-Annotated-2-12-18.pdf#page=6}{Tariff on Fares}.}
\item{RailTime}{Estimated travel time (schedule time) in minutes between
the source and destination station. This is not correlated to minutes
(\code{Min}) in Real-Time Rail Predictions.}
\item{PeakTime}{Fare during peak times (weekdays from opening to 9:30 AM
and 3-7 PM (EST), and weekends from midnight to closing).}
\item{OffPeakTime}{Fare during off-peak times (times other than the ones
described below).}
\item{SeniorDisabled}{Reduced fare for \href{https://www.wmata.com/fares/reduced.cfm}{senior citizens or people with disabilities.}}
}
}
\usage{
rail_destination(
  FromStationCode = NULL,
  ToStationCode = NULL,
  api_key = wmata_key()
)
}
\arguments{
\item{FromStationCode}{Station code for the origin station. Use the
\code{\link[=rail_stations]{rail_stations()}} function to return a list of all station codes.}

\item{ToStationCode}{Station code for the destination station. Use the
\code{\link[=rail_stations]{rail_stations()}} function to return a list of all station codes.}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A data frame containing station to station information
}
\description{
Returns a distance, fare information, and estimated travel time between any
two stations, including those on different lines. Omit both parameters to
retrieve data for all stations.
}
\examples{
\dontrun{
rail_destination("A01", "A08")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5476364f031f590f38092507/operations/5476364f031f5909e4fe3313}

Other Rail Station Information: 
\code{\link{rail_entrance}()},
\code{\link{rail_lines}()},
\code{\link{rail_path}()},
\code{\link{rail_stations}()},
\code{\link{rail_times}()},
\code{\link{station_info}()}
}
\concept{Rail Station Information}
