% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dby.R
\name{dby}
\alias{dby}
\alias{dby<-}
\alias{dby2}
\alias{dby2<-}
\alias{dbyr}
\title{Calculate summary statistics grouped by}
\usage{
dby(data, INPUT, ..., ID = NULL, ORDER = NULL, SUBSET = NULL, SORT = 0,
  COMBINE = !REDUCE, NOCHECK = FALSE, ARGS = NULL, NAMES,
  COLUMN = FALSE, REDUCE = FALSE, REGEX = mets.options()$regex,
  ALL = TRUE)
}
\arguments{
\item{data}{Data.frame}

\item{INPUT}{Input variables (character or formula)}

\item{...}{functions}

\item{ID}{id variable}

\item{ORDER}{(optional) order variable}

\item{SUBSET}{(optional) subset expression}

\item{SORT}{sort order (id+order variable)}

\item{COMBINE}{If TRUE result is appended to data}

\item{NOCHECK}{No sorting or check for missing data}

\item{ARGS}{Optional list of arguments to functions (...)}

\item{NAMES}{Optional vector of column names}

\item{COLUMN}{If TRUE do the calculations for each column}

\item{REDUCE}{Reduce number of redundant rows}

\item{REGEX}{Allow regular expressions}

\item{ALL}{if FALSE only the subset will be returned}
}
\description{
Calculate summary statistics grouped by variable
}
\details{
Calculate summary statistics grouped by


dby2 for column-wise calculations
}
\examples{
n <- 4
k <- c(3,rbinom(n-1,3,0.5)+1)
N <- sum(k)
d <- data.frame(y=rnorm(N),x=rnorm(N),id=rep(seq(n),k),num=unlist(sapply(k,seq)))
d2 <- d[sample(nrow(d)),]

dby(d2, y~id, mean)
dby(d2, y~id + order(num), cumsum)

dby(d,y ~ id + order(num), dlag)
dby(d,y ~ id + order(num), dlag, ARGS=list(k=1:2))
dby(d,y ~ id + order(num), dlag, ARGS=list(k=1:2), NAMES=c("l1","l2"))

dby(d, y~id + order(num), mean=mean, csum=cumsum, n=length)
dby(d2, y~id + order(num), a=cumsum, b=mean, N=length, l1=function(x) c(NA,x)[-length(x)])

dby(d, y~id + order(num), nn=seq_along, n=length)
dby(d, y~id + order(num), nn=seq_along, n=length)

d <- d[,1:4]
dby(d, x<0) <- list(z=mean)
d <- dby(d, is.na(z), z=1)

f <- function(x) apply(x,1,min)
dby(d, y+x~id, min=f)

dby(d,y+x~id+order(num), function(x) x)

f <- function(x) { cbind(cumsum(x[,1]),cumsum(x[,2]))/sum(x)}
dby(d, y+x~id, f)

## column-wise
a <- d
dby2(a, mean, median, REGEX=TRUE) <- '^[y|x]'~id
a
## wildcards 
dby2(a,'y*'+'x*'~id,mean) 


## subset
dby(d, x<0) <- list(z=NA)
d
dby(d, y~id|x>-1, v=mean,z=1)
dby(d, y+x~id|x>-1, mean, median, COLUMN=TRUE)

dby2(d, y+x~id|x>0, mean, REDUCE=TRUE)

dby(d,y~id|x<0,mean,ALL=FALSE)

a <- iris
a <- dby(a,y=1)
dby(a,Species=="versicolor") <- list(y=2)
}
\author{
Klaus K. Holst and Thomas Scheike
}
