% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{resmean.phreg}
\alias{resmean.phreg}
\alias{cif.yearslost}
\alias{rmst.phreg}
\title{Restricted mean for stratified Kaplan-Meier or Cox model with martingale standard errors}
\usage{
resmean.phreg(x, times = NULL, covs = NULL, ...)
}
\arguments{
\item{x}{phreg object}

\item{times}{possible times for which to report restricted mean}

\item{covs}{possible covariate for Cox model}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Restricted mean for stratified Kaplan-Meier or stratified Cox with martingale 
standard error. Standard error is computed using linear interpolation between 
standard errors at jump-times. Plots gives restricted mean at all times. 
Years lost can be computed based on this and decomposed into years lost for
different causes using the cif.yearslost function that is based on  
integrating the cumulative incidence functions.  
One particular feature of these functions are that the restricted mean and years-lost are 
computed for all event times as functions and can be plotted/viewed.  When times are given and beyond
the last event time withn a strata the curves are extrapolated using the estimates of 
cumulative incidence.
}
\examples{
data(bmt); bmt$time <- bmt$time+runif(408)*0.001
out1 <- phreg(Surv(time,cause!=0)~strata(tcell,platelet),data=bmt)

rm1 <- resmean.phreg(out1,times=10*(1:6))
summary(rm1)
par(mfrow=c(1,2))
plot(rm1,se=1)
plot(rm1,years.lost=TRUE,se=1)

## years.lost decomposed into causes
drm1 <- cif.yearslost(Event(time,cause)~strata(tcell,platelet),data=bmt,times=10*(1:6))
summary(drm1)
}
\author{
Thomas Scheike
}
