% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{sim.recurrent}
\alias{sim.recurrent}
\title{Simulation of two-stage recurrent events data based on Cox/Cox or Cox/Ghosh-Lin structure}
\usage{
sim.recurrent(cox1,coxd=NULL,coxc=NULL,n=1,data=NULL,
type=c("default","cox-cox","gl-cox"),id="id",
varz=1,share=1,cens=0.001,scale1=1,scaled=1,dependence=NULL,...)
}
\arguments{
\item{cox1}{cox/ghosh-lin for recurrent events}

\item{coxd}{cox for terminal event}

\item{coxc}{possible cox for censrong}

\item{n}{number of id's}

\item{data}{on which the models are fitted (to draw covariates)}

\item{type}{to specify type of simulation, if not default}

\item{id}{name of id variable}

\item{varz}{dependence frailty}

\item{share}{to fit patly shared random effects model}

\item{cens}{censoring rate for exponential censoring}

\item{scale1}{to scale baseline of recurrent events model}

\item{scaled}{to scale baseline of terminal event}

\item{dependence}{if dependence different from NULL, then uses simRecurrentList based on models given}

\item{...}{Additional arguments to simGLcox, nmin, nmax regulates linear approximation grid}
}
\description{
Simulation of two-stage recurrent events data based on Cox/Cox or Cox/Ghosh-Lin structure
}
\details{
Must specify two phreg objects, or a phreg and a recreg object, then simulates data from two-stage model
}
\examples{
data(hfactioncpx12)
hf <- hfactioncpx12
hf$x <- as.numeric(hf$treatment)
n <- 100
xr <- phreg(Surv(entry,time,status==1)~x+cluster(id),data=hf)
dr <- phreg(Surv(entry,time,status==2)~x+cluster(id),data=hf)
simcoxcox <- sim.recurrent(xr,dr,n=n,data=hf)
recGL <- recreg(Event(entry,time,status)~x+cluster(id),hf,death.code=2)
simglcox <- sim.recurrent(recGL,dr,n=n,data=hf)

}
\references{
Scheike (2024), Twostage recurrent events models, under review.
}
\author{
Thomas Scheike
}
