% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{gev.Nyr}
\alias{gev.Nyr}
\title{N-year return levels, median and mean estimate}
\usage{
gev.Nyr(par, nobs, N, type = c("retlev", "median", "mean"), p = 1/N)
}
\arguments{
\item{par}{vector of location, scale and shape parameters for the GEV distribution}

\item{nobs}{integer number of observation on which the fit is based}

\item{N}{integer number of observations for return level. See \strong{Details}}

\item{type}{string indicating the statistic to be calculated (can be abbreviated).}

\item{p}{probability indicating the return level, corresponding to the quantile at 1-1/p}
}
\value{
a list with components
\itemize{
\item{est} point estimate
\item{var} variance estimate based on delta-method
\item{type} statistic
}
}
\description{
N-year return levels, median and mean estimate
}
\details{
If there are \eqn{n_y} observations per year, the \code{L}-year return level is obtained by taking
\code{N} equal to \eqn{n_yL}.
}
