% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taildep.R
\name{taildep}
\alias{taildep}
\title{Coefficient of tail correlation and tail dependence}
\usage{
taildep(data, u = NULL, nq = 40, qlim = c(0.8, 0.99),
  depmeas = c("eta", "chi"), method = list(eta = c("emp", "betacop",
  "gpd", "hill"), chi = c("emp", "betacop")), confint = c("wald", "lrt"),
  level = 0.95, trunc = TRUE, ties.method = "random", plot = TRUE,
  ...)
}
\arguments{
\item{data}{an \eqn{n} by \eqn{d} matrix of multivariate observations}

\item{u}{vector of percentiles between 0 and 1 at which to evaluate the plot}

\item{nq}{number of quantiles at which to form a grid; only used if \code{u = NULL}.}

\item{qlim}{limits for the sequence \code{u}}

\item{depmeas}{dependence measure, either of \code{"eta"} or \code{"chi"}}

\item{method}{named list giving the estimation method for \code{eta} and \code{chi}. Default to \code{"emp"} for both.}

\item{confint}{string indicating the type of confidence interval for \eqn{\eta}, one of \code{"wald"} or \code{"lrt"}}

\item{level}{the confidence level required (default to 0.95).}

\item{trunc}{logical indicating whether the estimates and confidence intervals should be truncated in \eqn{[0,1]}}

\item{ties.method}{string indicating the type of method for \code{rank}; see \code{\link[base]{rank}} for a list of options. Default to \code{"random"}}

\item{plot}{logical; should graphs be plotted?}

\item{...}{additional arguments passed to \code{plot}; current support for \code{main}, \code{xlab}, \code{ylab}, \code{add} and further \code{pch}, \code{lty}, \code{type}, \code{col} for points; additional arguments for confidence intervals are handled via \code{cipch}, \code{cilty}, \code{citype}, \code{cicol}.}
}
\value{
a named list with elements
\itemize{
\item \code{u}: a \code{K} vector of percentile levels
\item \code{eta}: a \code{K} by 3 matrix with point estimates, lower and upper confidence intervals
\item \code{chi}: a \code{K} by 3 matrix with point estimates, lower and upper confidence intervals
}
}
\description{
For data with unit Pareto margins, the coefficient of tail dependence \eqn{\eta} is defined  via \deqn{\Pr(\min(X) > x) = L(x)x^{-1/\eta},}
where \eqn{L(x)} is a slowly varying function; \eqn{0 < \eta}. Ignoring the latter, several estimators of \eqn{\eta} can be defined. In unit Pareto margins, \eqn{\eta} is a shape parameter that can be estimated by fitting a generalized Pareto distribution above a high threshold. In exponential margins, \eqn{\eta} is a scale parameter and the maximum likelihood estimator of the latter is the Hill estimator. Both methods are based on peaks-over-threshold and the user can choose between pointwise confidence confint obtained through a likelihood ratio test statistic (\code{"lrt"}) or the Wald statistic (\code{"wald"}).
}
\details{
The most common approach for estimation is the empirical survival copula, by evaluating the proportion of sample minima with uniform margins that exceed a given \eqn{x}. An alternative estimator uses a smoothed estimator of the survival copula using Bernstein polynomial, resulting in the so-called \code{betacop} estimator. Approximate pointwise confidence confint for the latter are obtained by assuming the proportion of points is binomial.

The coefficient of tail correlation \eqn{\chi} is
\deqn{\chi = \lim_{u \to 1} \frac{\Pr(F_1(X_1)>u, \ldots, F_D(X_D)>u)}{1-u}.}
Asymptotically independent vectors have \eqn{\chi = 0}. The estimator uses an estimator of the survival copula
}
\examples{
\dontrun{
set.seed(765)
# Max-stable model
dat <- rmev(n = 1000, d = 4, param = 0.7, model = "log")
taildep(dat, confint = 'wald')
}
}
\seealso{
\code{\link[evd]{chiplot}} for bivariate empirical estimates of \eqn{\chi}{chi} and \eqn{\bar{\chi}}{chibar}.
}
