% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{gpdist}
\alias{gpdist}
\alias{pgp}
\alias{dgp}
\alias{qgp}
\alias{rgp}
\title{Generalized Pareto distribution}
\usage{
pgp(q, loc = 0, scale = 1, shape = 0, lower.tail = TRUE, log.p = FALSE)

dgp(x, loc = 0, scale = 1, shape = 0, log = FALSE)

qgp(p, loc = 0, scale = 1, shape = 0, lower.tail = TRUE)

rgp(n, loc = 0, scale = 1, shape = 0)
}
\arguments{
\item{loc}{location parameter.}

\item{scale}{scale parameter, strictly positive.}

\item{shape}{shape parameter.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p, log}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{x, q}{vector of quantiles}

\item{p}{vector of probabilities}

\item{n}{scalar number of observations}
}
\description{
Density function, distribution function, quantile function and
random number generation for the generalized Pareto
distribution.
}
\references{
Coles, S. G. (2001) \emph{An Introduction to Statistical
  Modeling of Extreme Values}, Springer-Verlag, London.
  \doi{10.1007/978-1-4471-3675-0_3}
}
