% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rdir}
\alias{rdir}
\title{Random variate generation for Dirichlet distribution on \eqn{S_{d}}{Sd}}
\usage{
rdir(n, alpha, normalize = TRUE)
}
\arguments{
\item{n}{sample size}

\item{alpha}{vector of parameter}

\item{normalize}{boolean. If \code{FALSE}, the function returns Gamma variates with parameter \code{alpha}.}
}
\value{
sample of dimension \code{d} (size of alpha) from the Dirichlet distribution.
}
\description{
A function to sample Dirichlet random variables, based on the representation as ratios of Gamma.
Note that the RNG will generate on the full simplex and the sum to one constraint is respected
here
}
\examples{
rdir(n=100, alpha=c(0.5,0.5,2),TRUE)
rdir(n=100, alpha=c(3,1,2),FALSE)
}

