% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCdiag.R
\name{thselect.ncpgp}
\alias{thselect.ncpgp}
\title{Northop and Coleman piecewise generalized Pareto threshold selection diagnostic}
\usage{
thselect.ncpgp(xdat, thresh, test = "score", plot = FALSE, level = 0.95, ...)
}
\arguments{
\item{xdat}{[vector] observations}

\item{thresh}{[vector] candidate thresholds}

\item{test}{[string] indicating whether to perform \code{score} test or likelihood ratio (\code{lr}) test. The latter requires fitting the alternative model, and so is more computationally expensive.}

\item{plot}{[logical]; if \code{TRUE}, return a plot with the p-value path.}

\item{level}{[double] confidence level for confidence interval, defaults to 0.95}

\item{...}{additional arguments, for backward compatibility purposes}
}
\value{
an object of class \code{mev_thselect_ncpgp} containing the test statistic (\code{stat}), the p-values (\code{pval}), the threshold candidates (\code{thresh}) and the selected threshold (\code{thresh0}).
}
\description{
The model tests the null hypothesis of a generalized Pareto above each threshold in \code{thresh} against the alternative of a piecewise generalized Pareto model with continuity constraints.
}
