% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mewAccum}
\alias{mewAccum}
\title{Update the class \code{mewTyp}}
\usage{
mewAccum(xx, av)
}
\arguments{
\item{xx}{(vector double) The vector of data with which to update
the MEW aveage}

\item{av}{(class mewTyp) The current state of the MEW average}
}
\value{
The updated instance of \code{av}
}
\description{
Update an S4 object of class \code{mewTyp} with a new
data point
}
\details{
If \code{av} is an S4 object of class \code{mewTyp} that
contains the current state of the MEW average and \code{xx} is a
new vector of data, the function \code{mewAccum} updates the MEW
average with \code{xx}.
}
\examples{
n_iter <- 1000

av <- mewInit(n_bin = 4, n_xx = 1, ff = 0.5)

for (i in 1:n_iter) {

  value <- runif(n=2)
  value[1] <- ((cos(value[1]*2*pi))^2)*(1 - exp(-0.01*i))
  value[2] <- (-((sin(value[2]*2*pi))^2))*(1 - exp(-0.01*i))
  value <- as.double(value)

  av <- mewAccum(xx = value, av = av)
}
}

