% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addExpression_function.R
\name{addExpression}
\alias{addExpression}
\title{Add RNAsequencing expression data list}
\usage{
addExpression(mgl, download = TRUE, saveDownload = FALSE, fpsource = "./",
  normalized = TRUE, xpGeneReads = TRUE, xpTranscriptReads = TRUE,
  xpGeneRpkm = TRUE, xpTranscriptRpkm = TRUE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{download}{A logical vector indicating if expression data should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}

\item{normalized}{A logical flag indicating if normalized gene expression data should be incorporated into the list.  Note: this is both the gene expression values and covariates used by GTEx to calculate eQTLs}

\item{xpGeneReads}{A logical flag indicating if gene read expression data should be incorporated into the list}

\item{xpTranscriptReads}{A logical flag indicating if transcript read expression data should be incorporated into the list}

\item{xpGeneRpkm}{A logical flag indicating if gene RPKM expression data should be incorporated into the list}

\item{xpTranscriptRpkm}{A logical flag indicating if transcript RPKM expression data should be incorporated into the list}
}
\description{
\code{addExpression} returns a list with the eighth through the eleventh elements as lists containing dataframes with tissue specific expression data from GTEx; see \url{http://www.gtexportal.org}. Element 8 is a list of reads by gene, element 9 of reads by transcript, element 10 of RPKM by gene, and element 11 of RPKM by transcript.
}
\details{
This gives tissue specific RNAsequencing data as reported by GTEx for the gene of interest.  It pulls data based on the gene name.  Each element of the list is a separate tissue.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addEnst(myMgl)}
\dontrun{myMgl <- addExpression(myMgl, download = TRUE, saveDownload = FALSE, 
fpsource = './', normalized = FALSE, xpGeneReads = TRUE, xpTranscriptReads = FALSE, 
xpGeneRpkm = FALSE, xpTranscriptRpkm = FALSE)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addGo}}, \code{\link{addGrasp}},
  \code{\link{addGwasCatalog}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

