% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths_MGWRSAR.R
\name{bandwidths_mgwrsar}
\alias{bandwidths_mgwrsar}
\title{Select optimal kernel and bandwidth from a list of models, kernels and bandwidth candidates.}
\usage{
bandwidths_mgwrsar(formula, data,coord,
fixed_vars='Intercept',Models='GWR',Kernels='bisq',control=list(),control_search=list())
}
\arguments{
\item{formula}{a formula.}

\item{data}{a dataframe or a spatial dataframe (sp package).}

\item{coord}{a dataframe or a matrix with coordinates, not required if data is a spatial dataframe, default NULL.}

\item{fixed_vars}{a vector with the names of spatially constant coefficient. For mixed model, if NULL, the default
#' is set to 'Intercept'.}

\item{Models}{character containing the type of model: Possible values are "OLS",
"SAR", "GWR" (default), "MGWR" , "MGWRSAR_0_0_kv","MGWRSAR_1_0_kv",
"MGWRSAR_0_kc_kv", "MGWRSAR_1_kc_kv", "MGWRSAR_1_kc_0".}

\item{Kernels}{a vector with the names of kernel type.}

\item{control}{list of extra control arguments for MGWRSAR wrapper - see MGWRSAR help.}

\item{control_search}{list of extra control arguments for bandwidth/kernel search - see section below.
 @details
 \itemize{
\item{search_W}{if TRUE select an optimal spatial weight matrix using a moment estimator, default FALSE.}
\item{kernels_w}{if search_W is TRUE, kernels_w is a vector of candidated kernels types, default NULL.}
\item{lower_c}{lower bound for bandwidth search (default, the approximate first decile of distances).}
\item{upper_c}{upper bound for bandwidth search  (default, the approximate last decile of distances).}
\item{lower_d}{lower bound for discrete kernels, default 2*k+1.}
\item{lower_dW}{ower bound for discrete kernels for finding optimal spatial weight matrix, default 2.}
\item{lower_cW}{lower bound for  bandwidth search for finding optimal spatial
weight matrix  (default approximate 0.005 quantile of distances).}
}}
}
\value{
bandwiths_MGWRSAR returns  a list with:
\item{config_model}{a vector with information about model, optimal kernel and
bandwidth for local regression, and optimal kernel and bandwith for spatial weight matrix W.}
\item{SSR}{The sum of square residuals.}
\item{CV}{The CV criteria.}
\item{model}{objects of class mgwrsar estimated using config_model}
}
\description{
Given a lm formula and a dataframe with coordinates, function bandwidths_mgwrsar optimizes the choice of
a bandwidth value for each of the chosen models and kernel types using a leave-one-out cross validation criteria.
A cross validated criteria is also used for selecting the best kernel type for a given model.
}
\details{
Given a lm formula and a dataframe with coordinates, for each model in
 \code{Models} for wich a bandwidth is required, this function optimizes the choice of
a bandwidth value for each of the chosen models and kernel types using a leave one out
cross validation criteria. A cross validated criteria is also used for selecting the best kernel type for a given model.
}
\examples{
\donttest{
library(mgwrsar)
data(mydata)
coord=as.matrix(mydata[,c("x_lat","y_lon")])
W=KNN(coord,8)
######################
#### Finding bandwith by hand
#####################

### kernel only space
model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,coord=coord,
fixed_vars=NULL,kernels=c('bisq_knn'),H=50,
Model = 'GWR', control=list(isgcv=FALSE,minv=1))
cat('SSR =')
summary_mgwrsar(model_GWR)

myCV<-function(H){model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,
coord=coord, fixed_vars=NULL,kernels=c('gauss_adapt'),H,
 Model = 'GWR',control=list(isgcv=TRUE))
model_GWR$SSR
}

res=optimize(myCV,upper=500,lower=10)
res

## model with optimal bandwith with adaptative gaussian kernel

model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,coord=coord,
fixed_vars=NULL,kernels=c ('gauss_adapt'),H=ceiling(res$minimum),
Model = 'GWR',control=list(isgcv=FALSE))
summary_mgwrsar(model_GWR)

######################
#### finding the bandwidths using bandwidths_mgwrsar
#####################


mytab<-bandwidths_mgwrsar(formula = 'Y_gwr~X1+X2+X3', data = mydata,coord=coord,
fixed_vars='Intercept',Models=c('GWR','MGWR'),Kernels=c('bisq_knn','gauss_adapt','gauss'),
control=list(),control_search=list (lower_d=8,lower_c=0.03,upper_c=0.65))

names(mytab)
names(mytab[['GWR']])

mytab[['GWR']]$config_model
mytab[['GWR']]$CV
summary(mytab[['GWR']]$model$Betav)


mytab[['GWR_2']]$config_model
mytab[['GWR_2']]$CV
summary(mytab[['GWR_2']]$model$Betav)

mytab[['GWR_3']]$config_model
mytab[['GWR_3']]$CV
summary(mytab[['GWR_3']]$model$Betav)

mytab[['MGWR']]$config_model
mytab[['MGWR']]$CV
mytab[['MGWR']]$model$Betac
summary(mytab[['MGWR']]$model$Betav)

mytab[['MGWR_2']]$config_model
mytab[['MGWR_2']]$CV
mytab[['MGWR_2']]$model$Betac
summary(mytab[['MGWR_2']]$model$Betav)

mytab[['MGWR_3']]$config_model
mytab[['MGWR_3']]$CV
mytab[['MGWR_3']]$model$Betac
summary(mytab[['MGWR_3']]$model$Betav)

mytab2<-bandwidths_mgwrsar(formula = 'Y_gwr~X1+X2+X3', data = mydata,coord=coord,
 fixed_vars='Intercept',Models=c('MGWRSAR_0_kc_kv'),Kernels=c('gauss_adapt'),
 control=list(),control_search=list(search_W=TRUE,kernels_w=c('bisq','gauss_adapt')))

mytab2[['MGWRSAR_0_kc_kv']]$config_model
mytab2[['MGWRSAR_0_kc_kv']]$CV
mytab2[['MGWRSAR_0_kc_kv']]$model$Betac
summary(mytab2[['MGWRSAR_0_kc_kv']]$model$Betav)

}
}
\references{
Geniaux, G. and Martinetti, D. (2017). A new method for dealing simultaneously with spatial autocorrelation and spatial heterogeneity in regression models. Regional Science and Urban Economics. (https://doi.org/10.1016/j.regsciurbeco.2017.04.001)


McMillen, D. and Soppelsa, M. E. (2015). A conditionally parametric probit model of
microdata land use in chicago. Journal of Regional Science, 55(3):391-415.

Loader, C. (1999). Local regression and likelihood, volume 47. Springer New York.

Franke, R. and Nielson, G. (1980). Smooth interpolation of large sets of scattered data.
International journal for numerical methods in engineering, 15(11):1691-1704.
}
\seealso{
MGWRSAR, summary_mgwrsar, plot_mgwrsar, predict_mgwrsar, kernelW_C
}
