% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rubin1_all.R
\name{rubin1.all}
\alias{rubin1.all}
\title{First Rubin rule (all peptide)}
\usage{
rubin1.all(
  data,
  metacond,
  funcmean = meanImp_emmeans,
  is.parallel = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{dataset}

\item{metacond}{a factor to specify the groups}

\item{funcmean}{function that should be used to compute the mean}

\item{is.parallel}{should parallel computing be used?}

\item{verbose}{should messages be displayed?}
}
\value{
A vector of estimated parameters.
}
\description{
Computes the first Rubin's rule for all the peptide.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
rubin1.all(datasim_imp[1:5,,],funcmean = meanImp_emmeans,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
