% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyplot.mads.R
\name{xyplot.mads}
\alias{xyplot.mads}
\title{Scatterplot of amputed and non-amputed data against weighted sum scores}
\usage{
\method{xyplot}{mads}(
  x,
  data,
  which.pat = NULL,
  standardized = TRUE,
  layout = NULL,
  colors = mdc(1:2),
  ...
)
}
\arguments{
\item{x}{A \code{mads} object, typically created by \code{\link{ampute}}.}

\item{data}{A string or vector of variable names that needs to be plotted. As 
a default, all variables will be plotted.}

\item{which.pat}{A scalar or vector indicating which patterns need to be plotted. 
As a default, all patterns are plotted.}

\item{standardized}{Logical. Whether the scatterplots need to be created
from standardized data or not. Default is TRUE.}

\item{layout}{A vector of two values indicating how the scatterplots of one 
pattern should be divided over the plot. For example, \code{c(2, 3)} indicates 
that the scatterplots of six variables need to be placed on 3 rows and 2 columns. 
There are several defaults for different #variables. Note that for more than 
9 variables, multiple plots will be created automatically.}

\item{colors}{A vector of two RGB values defining the colors of the non-amputed and 
amputed data respectively. RGB values can be obtained with \code{\link{hcl}}.}

\item{\dots}{Not used, but for consistency with generic}
}
\value{
A list containing the scatterplots. Note that a new pattern 
will always be shown in a new plot.
}
\description{
Plotting method to investigate relation between amputed data and the weighted sum 
scores. Based on \code{\link{lattice}}. \code{xyplot} produces scatterplots. 
The function plots the variables against the weighted sum scores. The function
automatically separates the amputed and non-amputed data to see the relation between
the amputation and the weighted sum scores.
}
\note{
The \code{mads} object contains all the information you need to 
make any desired plots. Check \code{\link{mads-class}} or the vignette \emph{Multivariate 
Amputation using Ampute} to understand the contents of class object \code{mads}.
}
\seealso{
\code{\link{ampute}}, \code{\link{bwplot}}, \code{\link{Lattice}} for 
an overview of the package, \code{\link{mads-class}}
}
\author{
Rianne Schouten, 2016
}
