% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter.mids}
\alias{filter.mids}
\title{Subset rows of a \code{mids} object}
\usage{
\method{filter}{mids}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{mids} object.}

\item{...}{Expressions that return a
logical value, and are defined in terms of the variables in \code{.data$data}.
If multiple expressions are specified, they are combined with the \code{&} operator.
Only rows for which all conditions evaluate to \code{TRUE} are kept.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
An S3 object of class \code{mids}
}
\description{
This function takes a \code{mids} object and returns a new
\code{mids} object that pertains to the subset of the data
identified by the expression in \dots. The expression may use
column values from the incomplete data in \code{.data$data}.
}
\note{
The function calculates a logical vector \code{include} of length \code{nrow(.data$data)}.
The function constructs the elements of the filtered \code{mids} object as follows:
\tabular{ll}{
\code{data}     \tab Select rows in \code{.data$data} for which \code{include == TRUE}\cr
\code{imp}      \tab Select rows each imputation \code{data.frame} in \code{.data$imp} for which \code{include == TRUE}\cr
\code{m}        \tab Equals \code{.data$m}\cr
\code{where}    \tab Select rows in \code{.data$where} for which \code{include == TRUE}\cr
\code{blocks}   \tab Equals \code{.data$blocks}\cr
\code{call}     \tab Equals \code{.data$call}\cr
\code{nmis}     \tab Recalculate \code{nmis} based on the selected \code{data} rows\cr
\code{method}   \tab Equals \code{.data$method}\cr
\code{predictorMatrix} \tab Equals \code{.data$predictorMatrix}\cr
\code{visitSequence}   \tab Equals \code{.data$visitSequence}\cr
\code{formulas}  \tab Equals \code{.data$formulas}\cr
\code{post}      \tab Equals \code{.data$post}\cr
\code{blots}     \tab Equals \code{.data$blots}\cr
\code{ignore}    \tab Select positions in \code{.data$ignore} for which \code{include == TRUE}\cr
\code{seed}            \tab Equals \code{.data$seed}\cr
\code{iteration}       \tab Equals \code{.data$iteration}\cr
\code{lastSeedValue}   \tab Equals \code{.data$lastSeedValue}\cr
\code{chainMean}       \tab Set to \code{NULL}\cr
\code{chainVar}        \tab Set to \code{NULL}\cr
\code{loggedEvents}    \tab Equals \code{.data$loggedEvents}\cr
\code{version}    \tab Replaced with current version\cr
\code{date}       \tab Replaced with current date
}
}
\examples{
imp <- mice(nhanes, m = 2, maxit = 1, print = FALSE)

# example with external logical vector
imp_f <- filter(imp, c(rep(TRUE, 13), rep(FALSE, 12)))

nrow(complete(imp))
nrow(complete(imp_f))

# example with calculated include vector
imp_f2 <- filter(imp, age >= 2 & hyp == 1)
nrow(complete(imp_f2))  # should be 5
}
\seealso{
\code{\link[dplyr]{filter}}
}
\author{
Patrick Rockenschaub
}
\keyword{manip}
