.norm.draw2 <-
  function(y, ry, x, ridge = 1e-05, vcovcor=vcovcor,correct=correct, ...) {
    xobs <- x[ry, ]
    yobs <- y[ry]
    xtx <- t(xobs) %*% xobs
    pen <- ridge * diag(xtx)
    if (length(pen) == 1) 
      pen <- matrix(pen)
    v <- solve(xtx + diag(pen))
    coef <- t(yobs %*% xobs %*% v)
    residuals <- yobs - xobs %*% coef
    df <- max(sum(ry) - ncol(x), 1)  
    v <- vcovcor
    sigma.star <- sqrt(sum((residuals)^2)/rchisq(1, df))/sqrt(correct)
    #print(sigma.star)
    sigma.star <-mean(sigma.star)
    #print(sigma.star)
    beta.star <- coef + (t(chol((v + t(v))/2)) %*% rnorm(ncol(x))) * sigma.star
    parm <- list(coef, beta.star, sigma.star)  
    names(parm) <- c("coef", "beta", "sigma")  
    return(parm)
  }

.Random.seed <-
c(403L, 10L, -1910847694L, 239932973L, 1140268263L, -393351666L, 
1313444840L, -562295317L, 1029723785L, 1518347800L, -1025643194L, 
1905413025L, 1771710003L, -928154718L, -1684787564L, 232090903L, 
-901891315L, -801584604L, -588991990L, 1903733621L, 1481535183L, 
-1593056810L, -757248640L, 1312277955L, 1702241121L, 520772048L, 
-286756562L, -1757849383L, -1183264021L, -1917108390L, -1851528932L, 
-292478945L, 1423182965L, -1801103092L, 1538274530L, 983539133L, 
2080541239L, 1757575390L, -687721448L, 1111133051L, 1566448409L, 
-85669976L, -387250346L, -1874763823L, -1735836797L, 945913362L, 
-780428892L, -752288409L, -1092533571L, -471481804L, -1606780518L, 
592602597L, -548298369L, -264828666L, -219049328L, -1932774605L, 
1154263249L, 201902720L, -918955170L, 231221417L, 1525951323L, 
1032763754L, -1932973044L, -375976881L, 964992261L, -836428356L, 
1836513426L, -1247241331L, 501849031L, 949338286L, -1715728120L, 
-253686005L, -1502381591L, -872268104L, -159635098L, 910420481L, 
-1991547757L, 167280450L, -1741885196L, -1098273545L, -1904171795L, 
-559933564L, -1579734614L, 1786613525L, -1378857553L, -414214730L, 
1261456352L, -1340423389L, -1189845951L, 1227831088L, -211569330L, 
1430042553L, 206893515L, 1212658298L, 194000764L, -1289209921L, 
-19185515L, 354537132L, 2119154818L, -800699299L, 812307287L, 
-2099761602L, 991912568L, 1070502235L, -382189383L, 1846415624L, 
-1677646922L, -440033039L, 1593759523L, 2070704498L, -1415920700L, 
770944903L, 1007342941L, 3066708L, 2122051962L, -315622203L, 
-1115349473L, 1147533734L, 1866873648L, -411133485L, -1025646607L, 
-908154592L, -540584002L, -1639516215L, 1007884155L, -801485494L, 
-920671828L, 353895599L, -522781083L, 1388422684L, 777156722L, 
319946477L, 665756455L, 1555660622L, -212191320L, 52544427L, 
18809033L, 2030291160L, -1374358138L, 2114088033L, 348298739L, 
1605983330L, 363764436L, 1762978775L, -47636019L, -1226492572L, 
1563148618L, -908072779L, 290553871L, 2114238742L, 153002944L, 
395374467L, 1790500257L, 1904705936L, -2116990354L, -970331111L, 
529297579L, 51025050L, -1199135652L, 1487872351L, -1126448331L, 
754173644L, 1340691490L, -1197889923L, 535886711L, 147109022L, 
-454003880L, 44578491L, 1135433817L, -1467266072L, 1523994134L, 
-1225436783L, -76971453L, -940703406L, 1078449636L, -1573225433L, 
378390653L, 2034111860L, 934107482L, 1458130853L, 2015915967L, 
-1802542010L, 362758864L, 985074931L, 1385376273L, -206803904L, 
-587644898L, -1299718423L, -2062230501L, -224234454L, 496879436L, 
-2006090481L, -621715387L, -1228994052L, 295422034L, 906326477L, 
1929171847L, -1591544210L, 1830303304L, -532934581L, 1167948201L, 
1309783288L, -1303592922L, 68538689L, -1006899501L, 2144327298L, 
1393745076L, 2036081719L, -125876435L, -447069116L, 499902826L, 
2049508821L, -12410001L, -2111554954L, 1135689120L, 1911925347L, 
2080439041L, 1171337840L, -2081985010L, -756390279L, 41062923L, 
177326906L, 70660668L, -2007273089L, -184755499L, 1756347116L, 
1607945282L, -437689443L, 223443479L, -1238035348L, -1474056524L, 
2022811666L, 216074208L, 1432216524L, 1850154464L, 53953058L, 
-268718808L, -1399044852L, -1594655172L, 874295538L, 9064176L, 
-369651900L, -569508264L, -1808438726L, 2052501232L, -1430040388L, 
-1353068012L, 2101204162L, 539554912L, -451011204L, -188755760L, 
961184802L, -565068120L, -483376244L, 224734652L, -941646798L, 
1835509568L, -1407204172L, 1546880840L, 1698384570L, 665771792L, 
514751724L, -916372396L, 1877085970L, -1485260896L, -368127028L, 
-371371168L, 127091906L, 1740805672L, -1263479380L, 2071022396L, 
-479348878L, -8923344L, -1374570972L, 298959928L, -1828298534L, 
1540470160L, -1686963460L, -780553324L, -1586546878L, 851697152L, 
-1865472452L, 1170991696L, 1253971618L, -1325325496L, -158608884L, 
-2120468260L, 1963719250L, -637087616L, -39711916L, 1538934248L, 
218693370L, 240298832L, 155905068L, 155740532L, 899085970L, -227430816L, 
-2084952436L, 918132576L, -1417331998L, 665628840L, -916685620L, 
-1448910340L, -2024669262L, -1866520080L, -315595324L, 1999108952L, 
-128438406L, 834524592L, -1187424836L, -1138146220L, -685455422L, 
1426081568L, 1631632316L, 1267280L, -1282078238L, -100756120L, 
-1473278644L, -1093208836L, 904043250L, -185482496L, 1621872244L, 
1234392072L, -1291953734L, -117247024L, 704284140L, 1614376852L, 
1780858578L, 478145120L, 1072905548L, -1214791392L, -1901724030L, 
-852232728L, -96857108L, 871979580L, 1078597234L, -410768528L, 
-1602481884L, -1483267528L, 908155290L, -18174512L, 1648246204L, 
1211516052L, -1037793150L, -490349120L, 1895841596L, 1848111248L, 
-1846973662L, 333486600L, -996808436L, 1424882076L, 893651474L, 
228269952L, -1216017644L, -757133016L, -1110206406L, -500311088L, 
1508363884L, -2030497228L, 938616466L, -685273760L, -1242470068L, 
-1277565984L, 1552994722L, -348956248L, -649292148L, -690876996L, 
721183346L, -866333712L, 664433220L, -1130246056L, -502987718L, 
1976792176L, 1968288828L, 1202345236L, 654326466L, -944245024L, 
1219972220L, -1419388208L, 1004554658L, -537224152L, -777988340L, 
310009276L, 1306629938L, -1537466688L, -1938456524L, -1571619128L, 
-1918728006L, -1484934512L, 2105597676L, 1691322964L, 675434130L, 
-1292808928L, -1159772724L, -746012960L, 1211442370L, 1971936296L, 
888513452L, 476851900L, -131278862L, 1735797296L, 204800932L, 
1478761912L, 1168875354L, -1083088752L, 1091907452L, -365071084L, 
2000197954L, 697988352L, 1528295868L, -339765936L, 1093280034L, 
1364611656L, -38956020L, 2018234972L, -1953360430L, 1750928896L, 
1345108308L, 1774517480L, -482498310L, 408603344L, 1516732204L, 
-1994156812L, 1906388370L, 1315619168L, 1836830732L, 834697440L, 
1981728354L, -1508777816L, -301658036L, -368695428L, -1985467086L, 
-283103632L, 639518532L, -627008552L, -786864262L, 1251058736L, 
1272981436L, -1437939116L, -1062606782L, 1984296608L, 2004841148L, 
-89595952L, 1931665762L, -1462719768L, -1991308084L, 863910396L, 
1063211506L, -2029262720L, 980917748L, 1897736840L, -122222790L, 
-1588342448L, 21786732L, 1550472596L, 557524050L, 956717810L, 
-266943680L, -422877015L, 838638875L, -2133095700L, 120657658L, 
-418461905L, -1710364871L, 2006571342L, -593672292L, -1681570547L, 
196988791L, 1047702400L, -233995810L, 1331181227L, 2126125485L, 
502296090L, -1254158120L, -87081663L, 1047999987L, 218354708L, 
-341337694L, -874664265L, -37787519L, 1198678150L, 1063949508L, 
44937717L, 136653919L, 2003799736L, 1178771350L, -8268381L, 374147429L, 
-1670553470L, -1880192528L, -354959463L, -783631989L, 234808444L, 
-91631958L, -1173067553L, 159022697L, 1537617022L, 309519468L, 
223311037L, -1198412409L, 899385712L, 582175758L, 621347131L, 
2079362589L, 1683329738L, -1975009816L, 1032741585L, 821944003L, 
1001657796L, 43737714L, -381805753L, -11066607L, 918072982L, 
-1961122828L, -1063055995L, -1124466481L, 1006594504L, 1578109030L, 
-388096365L, 377802229L, -37105710L, 1796697120L, -231813623L, 
-520308933L, 68385420L, 455614234L, 461369743L, 1149972185L, 
1482838382L, -560227076L, 69391981L, -2080366057L, 1749456864L, 
173675454L, 1792913803L, 673776141L, 47431226L, -177637768L, 
1393303073L, 881365203L, -583577612L, 32393346L, 2072633623L, 
-1273899039L, 1621426470L, -507273180L, -1563311403L, -1388876161L, 
-775676136L, 903974454L, 1019019459L, -716374779L, -253393758L, 
414612112L, -796654023L, 931485419L, -1994618916L, -1773204982L, 
1069063423L, -1963091639L, 188779230L, 1787000972L, -469626787L, 
-360112537L, 757600144L, -689339474L, -585373093L, -2118572483L, 
-2066114390L, 1685023048L, 599121265L, -1412850973L, -1919143452L, 
233700626L, 807383271L, 1772488369L, 1084538102L, 701046548L, 
-796575707L, 1719090479L, 570692328L, -1574326330L, 1491980915L, 
-545581867L, -1763477838L, -1963790720L, -791144855L, -1788773669L, 
1239025196L, -1676704198L, -1842495249L, -1140192391L, 1420347406L, 
-1360974372L, -905896371L, -1103086153L, -244640960L, -265199074L, 
1614800107L, 1354378349L, -894759718L, 1172264088L, -1805987071L, 
-1406945101L, -307227692L, -1140420894L, -118878345L, -1357737279L, 
1238803014L, 978849156L, -1523829963L, -706399969L, 1038456952L, 
-919403178L, 644987875L, -2055137883L, -1534265278L, 823014960L, 
-1907224999L, -909342773L, 2103679036L, -21043606L, -558859105L, 
612175145L, -197133890L, 1533103397L)
