% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_propdiff_nw.R
\name{pool_propdiff_nw}
\alias{pool_propdiff_nw}
\title{Calculates the pooled difference between proportions and confidence
intervals according to Newcombe-Wilson (NW) across multiply imputed datasets.}
\usage{
pool_propdiff_nw(object, conf.level = 0.95)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis'.).}

\item{conf.level}{Confidence level of the confidence intervals.
Mostly set at 0.95.}
}
\value{
The Proportion and the Confidence intervals according to Newcombe-Wilson.
}
\description{
\code{pool_propdiff_nw} Calculates the pooled difference between proportions
and confidence intervals according to Newcombe-Wilson (NW) across
multiply imputed datasets.
}
\details{
The \code{pool_propdiff_nw} function uses information from separate
exposure groups. It is therefore important to first use the \code{propdiff_wald}
function and to set strata = TRUE in that function.
}
\examples{

library(magrittr)
lbpmilr \%>\%
  df2milist(impvar="Impnr") \%>\%
    with(expr=propdiff_wald(Chronic ~ Radiation, strata = TRUE)) \%>\%
      pool_propdiff_nw()

# Same as
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
res <- with(imp_dat, expr=propdiff_wald(Chronic ~ Radiation, strata = TRUE))
res <- pool_propdiff_nw(res)

}
\references{
Yulia Sidi & Ofer Harel (2021): Difference Between Binomial
Proportions Using Newcombe’s Method With Multiple Imputation for Incomplete
Data, The American Statistician, DOI:10.1080/00031305.2021.1898468
}
\seealso{
\code{\link{with.milist}}, \code{\link{propdiff_wald}}
}
\author{
Martijn Heymans, 2021
}
