% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propdiff_wald.R
\name{propdiff_wald}
\alias{propdiff_wald}
\title{Calculates the difference between proportions and standard error
according to Wald}
\usage{
propdiff_wald(y, x, formula, data, strata = FALSE)
}
\arguments{
\item{y}{0-1 binary response variable.}

\item{x}{0-1 binary independent variable.}

\item{formula}{A formula object to specify the model as normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}

\item{strata}{If TRUE the proportion, se and n of each group is provided.
Default is FALSE. Has to be used in combination with function
\code{pool_propdiff_wilson}}
}
\value{
The difference between proportions, standard error and complete data
degrees of freedom (dfcom) as n-1.
}
\description{
\code{propdiff_wald} Calculates the difference between proportions and
standard error according to Wald and degrees of freedom to
be used in function \code{with.miceafter}.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_wald(Chronic ~ Radiation))

# proportions in each subgroup
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=propdiff_wald(Chronic ~ Radiation, strata=TRUE))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_propdiff_nw}}
}
\author{
Martijn Heymans, 2021
}
