% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assumptions.R
\name{assumptions_paruv}
\alias{assumptions_paruv}
\title{Determine the assumptions for the parametric comparison test}
\usage{
assumptions_paruv(data, factors)
}
\arguments{
\item{data}{Data used in the parametric test (rows correspond to
observations, columns to principal components).}

\item{factors}{Groups to which rows of \code{data} belong to.}
}
\value{
An object of class \code{assumptions_paruv} which is a list
containing two elements:
\describe{
 \item{\code{uvntest}}{List of results from the Shapiro-Wilk normality test
       (\code{\link[stats]{shapiro.test}}), one result per group per
       principal component.}
 \item{\code{vartest}}{Result of Bartlett test for homogeneity of variances
       (\code{\link[stats]{bartlett.test}}).}
}
}
\description{
Determine two assumptions for the parametric comparison tests (i.e. either
\code{\link[stats]{t.test}} or \code{\link[stats]{aov}}) for each principal
component, namely: a) univariate normality of each group; b) homogeneity of
variances.
}
\examples{

# Determine the assumptions of applying ANOVA to each column (dependent
# variable) of the iris data (i.e. normality of each group and homogeneity of
# variances)
a <- assumptions_paruv(iris[, 1:4], iris[, 5])

}
